const ERROR_LOG_KEY="sunoOfflineErrorLog",MAX_ERRORS=50,ErrorLevel={DEBUG:"debug",INFO:"info",WARN:"warn",ERROR:"error",FATAL:"fatal"},ErrorCategory={NETWORK:"network",STORAGE:"storage",API:"api",UI:"ui",INDEXING:"indexing",DOWNLOAD:"download",UNKNOWN:"unknown"};class SunoErrorHandler{constructor(){this.errorLog=[],this.listeners=[],this.settingsCache=null,this.initialized=!1}async init(){if(!this.initialized)try{const r=await chrome.storage.local.get([ERROR_LOG_KEY,"sunoOfflineSettings"]);this.errorLog=r[ERROR_LOG_KEY]||[],this.settingsCache=r.sunoOfflineSettings||{errorReporting:!0},this.initialized=!0,this.setupGlobalHandlers()}catch(r){}}setupGlobalHandlers(){"undefined"!=typeof window&&(window.onerror=(r,e,t,o,n)=>(this.capture({message:r?.toString()||"Unknown error",source:e,line:t,col:o,stack:n?.stack,category:ErrorCategory.UNKNOWN,level:ErrorLevel.ERROR}),!1),window.onunhandledrejection=r=>{this.capture({message:r.reason?.message||"Unhandled promise rejection",stack:r.reason?.stack,category:ErrorCategory.UNKNOWN,level:ErrorLevel.ERROR})})}async capture(r){if(!this.settingsCache?.errorReporting&&r.level!==ErrorLevel.FATAL)return;const e={id:crypto.randomUUID?.()||Date.now().toString(),time:(new Date).toISOString(),message:r.message||"Unknown error",category:r.category||ErrorCategory.UNKNOWN,level:r.level||ErrorLevel.ERROR,source:r.source,line:r.line,col:r.col,stack:r.stack,context:r.context,userAgent:"undefined"!=typeof navigator?navigator.userAgent:"unknown",url:"undefined"!=typeof window?window.location.href:"background"};this.errorLog.unshift(e),this.errorLog=this.errorLog.slice(0,50);try{await chrome.storage.local.set({[ERROR_LOG_KEY]:this.errorLog})}catch(r){}return this.listeners.forEach(r=>{try{r(e)}catch(r){}}),e}wrap(r,e={}){return async(...t)=>{try{return await r(...t)}catch(o){throw await this.capture({message:o.message,stack:o.stack,category:e.category||ErrorCategory.UNKNOWN,level:e.level||ErrorLevel.ERROR,source:e.source||r.name,context:{args:t.map(r=>typeof r),...e}}),o}}}async networkError(r,e,t={}){return this.capture({message:r,category:ErrorCategory.NETWORK,level:ErrorLevel.ERROR,context:{status:e?.status,statusText:e?.statusText,url:e?.url,...t}})}async apiError(r,e,t={}){return this.capture({message:r,category:ErrorCategory.API,level:ErrorLevel.ERROR,source:e,context:t})}async storageError(r,e,t={}){return this.capture({message:r,category:ErrorCategory.STORAGE,level:ErrorLevel.ERROR,source:e,context:t})}onError(r){return this.listeners.push(r),()=>{this.listeners=this.listeners.filter(e=>e!==r)}}getLog(){return[...this.errorLog]}async clearLog(){this.errorLog=[],await chrome.storage.local.set({[ERROR_LOG_KEY]:[]})}getStats(){const r=Date.now(),e=r-36e5,t=r-864e5;return{total:this.errorLog.length,lastHour:this.errorLog.filter(r=>new Date(r.time).getTime()>e).length,lastDay:this.errorLog.filter(r=>new Date(r.time).getTime()>t).length,byCategory:this.errorLog.reduce((r,e)=>(r[e.category]=(r[e.category]||0)+1,r),{}),byLevel:this.errorLog.reduce((r,e)=>(r[e.level]=(r[e.level]||0)+1,r),{})}}}const errorHandler=new SunoErrorHandler;"undefined"!=typeof window&&(window.SunoError=errorHandler,window.ErrorLevel=ErrorLevel,window.ErrorCategory=ErrorCategory),errorHandler.init().catch(console.error);