const SETTINGS_KEY="sunoOfflineSettings",ERROR_LOG_KEY="sunoOfflineErrorLog";function sendMessage(t,e={}){return chrome.runtime.sendMessage({action:t,...e})}const DEFAULT_SETTINGS={privacyTier:1,errorReporting:!0,publicCurationMode:!1,lastAnalyticsSubmit:null,lastUpdated:null};let settings={...DEFAULT_SETTINGS},errorLog=[],analytics=null,globalInsights=null,cachedUserStats=null;async function loadSettings(){try{const t=await chrome.storage.local.get([SETTINGS_KEY,ERROR_LOG_KEY]);settings={...DEFAULT_SETTINGS,...t[SETTINGS_KEY]||{}},errorLog=t[ERROR_LOG_KEY]||[],document.querySelector(`input[name="privacyTier"][value="${settings.privacyTier}"]`).checked=!0,document.getElementById("errorReporting").checked=settings.errorReporting;const e=document.getElementById("publicCurationMode");e&&(e.checked=settings.publicCurationMode||!1),renderErrorLog()}catch(t){}}async function saveSettings(){try{settings.lastUpdated=(new Date).toISOString(),await chrome.storage.local.set({[SETTINGS_KEY]:settings}),showSaveStatus()}catch(t){showToast("Failed to save settings","error")}}function showSaveStatus(){const t=document.getElementById("saveStatus");t.textContent="Saving...",t.style.color="var(--text-muted)",setTimeout(()=>{t.textContent="All changes saved",t.style.color="var(--success)"},500)}function handleTierChange(t){settings.privacyTier=parseInt(t.target.value),saveSettings(),showToast(`Privacy set to: ${["Ghost Mode","Anonymous Contributor","Insight Sharer","Community Member"][settings.privacyTier]}`,"success")}async function loadErrorLog(){try{const t=await chrome.storage.local.get([ERROR_LOG_KEY]);errorLog=t[ERROR_LOG_KEY]||[],renderErrorLog()}catch(t){}}function renderErrorLog(){const t=document.getElementById("errorList");0!==errorLog.length?t.innerHTML=errorLog.slice(0,20).map(t=>`\n    <div class="error-item">\n      <span class="error-item-time">${formatTime(t.time)}</span>\n      <span class="error-item-msg">${escapeHtml(t.message)}</span>\n    </div>\n  `).join(""):t.innerHTML='<p class="empty-state">No errors logged ✓</p>'}document.querySelectorAll(".privacy-tier").forEach(t=>{t.addEventListener("click",e=>{if("INPUT"===e.target.tagName)return;const n=t.querySelector('input[type="radio"]');n.checked=!0,n.dispatchEvent(new Event("change",{bubbles:!0}))})}),document.querySelectorAll('input[name="privacyTier"]').forEach(t=>{t.addEventListener("change",handleTierChange)}),document.getElementById("errorReporting")?.addEventListener("change",t=>{settings.errorReporting=t.target.checked,saveSettings(),showToast(t.target.checked?"Error reporting enabled":"Error reporting disabled","success")}),document.getElementById("publicCurationMode")?.addEventListener("change",t=>{settings.publicCurationMode=t.target.checked,saveSettings(),showToast(t.target.checked?"🌐 Public Curation Mode enabled! External links and visibility options now available.":"Public Curation Mode disabled","success")}),document.getElementById("btnClearErrors")?.addEventListener("click",async()=>{errorLog=[],await chrome.storage.local.set({[ERROR_LOG_KEY]:[]}),renderErrorLog(),showToast("Error log cleared","success")}),document.getElementById("btnExportAll")?.addEventListener("click",async()=>{try{const t=await chrome.storage.local.get(null),e=await SunoOfflineDB.getAllClips(),n={settings:t[SETTINGS_KEY]||{},userPrefs:t.sunoUserPrefs||{},config:t.sunoOfflineConfig||{},clips:e,exportedAt:(new Date).toISOString(),version:"1.0.0"},s=new Blob([JSON.stringify(n,null,2)],{type:"application/json"}),a=URL.createObjectURL(s),o=document.createElement("a");o.href=a,o.download=`suno-explorer-full-backup-${(new Date).toISOString().split("T")[0]}.json`,document.body.appendChild(o),o.click(),document.body.removeChild(o),URL.revokeObjectURL(a),showToast("Full backup exported!","success")}catch(t){showToast("Export failed: "+t.message,"error")}});let publicExportData=null;async function initPublicExport(){const{sunoOfflineSettings:t}=await chrome.storage.local.get("sunoOfflineSettings"),e=t?.publicCurationMode||!1,n=document.getElementById("exportPublicSection");n&&(n.style.display=e?"":"none"),e&&await updatePublicExportStats()}async function updatePublicExportStats(){const t=document.getElementById("publicExportStats");if(t)try{const e=await SunoOfflineDB.getPublicLibrary(),n=(await SunoOfflineDB.getUserPrefs()).customNames||{},s=await sendMessage("getAllManualLinks"),a=s?.links||{},o=await SunoOfflineDB.getAllClips(),i=new Map(o.map(t=>[t.id,t])),r=new Set(e.map(t=>t.id)),l=new Set,c={},d=t=>a[t.id]?a[t.id]:SunoOfflineDB.getParentId(t);for(const t of e){let e=t.id;const n=new Set;for(;e&&!n.has(e);){n.add(e);const t=i.get(e);if(!t)break;const s=d(t);if(!s)break;a[e]&&(c[e]=a[e]),r.has(s)||l.add(s),e=s}}const u=o.filter(t=>l.has(t.id));for(const t of u)t._lineageOnly=!0,e.push(t);const g=new Map;for(const t of e){const e=SunoOfflineDB.normalizeTitle(t.title);g.has(e)||g.set(e,[]),g.get(e).push(t)}const p=e.filter(t=>t.externalLinks?.length>0).length,m=(e.filter(t=>"released"===t.releaseStatus).length,Object.keys(c).length);t.innerHTML=`\n      <span class="stat"><strong>${g.size}</strong> songs</span>\n      <span class="stat"><strong>${e.length}</strong> versions</span>\n      <span class="stat"><strong>${p}</strong> with links</span>\n      <span class="stat"><strong>${m}</strong> manual links</span>\n    `,publicExportData={clips:e,customNames:n,manualLinks:c,songCount:g.size,versionCount:e.length}}catch(e){t.innerHTML='<span class="stat error">Failed to load</span>'}}function showPublicPreviewModal(t){document.getElementById("publicPreviewModal")?.remove();const e=new Map;for(const n of t.clips){const s=SunoOfflineDB.normalizeTitle(n.title),a=t.customNames[s],o=a||n.title;e.has(s)||e.set(s,{title:o,customName:a,versions:[]}),e.get(s).versions.push(n)}const n=document.createElement("div");n.id="publicPreviewModal",n.className="modal-overlay",n.style.cssText="position: fixed; top: 0; left: 0; right: 0; bottom: 0; background: rgba(0,0,0,0.8); display: flex; align-items: center; justify-content: center; z-index: 10000;",n.innerHTML=`\n    <div class="modal-content preview-modal" style="background: var(--bg-secondary, #1a1a2e); border-radius: 12px; max-width: 600px; width: 90%; max-height: 80vh; display: flex; flex-direction: column; overflow: hidden;">\n      <div class="modal-header" style="padding: 20px; border-bottom: 1px solid var(--border, #333); position: relative;">\n        <h2 style="margin: 0 0 4px 0;">🌐 Public Library Preview</h2>\n        <p style="margin: 0; color: var(--text-secondary, #888); font-size: 14px;">${e.size} songs • ${t.clips.length} versions</p>\n        <button class="modal-close" id="closePreviewModal" style="position: absolute; top: 16px; right: 16px; background: none; border: none; font-size: 20px; cursor: pointer; color: var(--text-secondary, #888);">✕</button>\n      </div>\n      <div class="preview-list" style="flex: 1; overflow-y: auto; padding: 16px;">\n        ${Array.from(e.values()).map(t=>`\n          <div class="preview-song" style="display: flex; gap: 12px; padding: 12px; background: var(--bg-elevated, #252540); border-radius: 8px; margin-bottom: 8px;">\n            <img class="preview-thumb" src="${t.versions[0]?.image_url||""}" alt="" style="width: 50px; height: 50px; border-radius: 6px; object-fit: cover;">\n            <div class="preview-info" style="flex: 1; min-width: 0;">\n              <div class="preview-title" style="font-weight: 500; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;">${escapeHtml(t.title)}</div>\n              <div class="preview-meta" style="font-size: 12px; color: var(--text-secondary, #888);">\n                ${t.versions.length} version${t.versions.length>1?"s":""}\n                ${t.versions.some(t=>t.externalLinks?.length)?" • 🔗 Has links":""}\n                ${t.versions.some(t=>"released"===t.releaseStatus)?" • ✅ Released":""}\n              </div>\n            </div>\n          </div>\n        `).join("")}\n      </div>\n      <div class="modal-actions" style="padding: 16px 20px; border-top: 1px solid var(--border, #333); display: flex; justify-content: flex-end; gap: 12px;">\n        <button class="btn btn-ghost" id="closePreviewBtn">Close</button>\n        <button class="btn btn-primary" id="exportFromPreviewBtn">📤 Export for Web</button>\n      </div>\n    </div>\n  `,document.body.appendChild(n),document.getElementById("closePreviewModal").addEventListener("click",()=>n.remove()),document.getElementById("closePreviewBtn").addEventListener("click",()=>n.remove()),document.getElementById("exportFromPreviewBtn").addEventListener("click",()=>{n.remove(),document.getElementById("btnExportPublic")?.click()}),n.addEventListener("click",t=>{t.target===n&&n.remove()})}function escapeHtml(t){const e=document.createElement("div");return e.textContent=t||"",e.innerHTML}async function initAnalytics(){if("undefined"!=typeof SunoAnalytics){analytics=new SunoAnalytics;try{cachedUserStats=await gatherAnalyticsStats()}catch(t){}await fetchGlobalInsights()}}async function fetchGlobalInsights(){if(analytics)try{globalInsights=await analytics.getGlobalInsights(),renderGlobalInsights()}catch(t){}}function renderGlobalInsights(){const t=document.getElementById("globalInsights");if(!t)return;if(!globalInsights||0===globalInsights.total_users)return void(t.innerHTML='\n      <div class="insights-placeholder">\n        <p>📊 No community data yet</p>\n        <p class="muted">Be one of the first contributors!</p>\n      </div>\n    ');const e=renderPercentileBadge(),n=renderGenreComparison(),s=renderModelComparison();t.innerHTML=`\n    <div class="global-stats-grid">\n      <div class="global-stat">\n        <span class="global-stat-value">${globalInsights.total_users.toLocaleString()}</span>\n        <span class="global-stat-label">Contributors</span>\n      </div>\n      <div class="global-stat">\n        <span class="global-stat-value">${formatNumber(globalInsights.total_songs_all_users)}</span>\n        <span class="global-stat-label">Total Songs</span>\n      </div>\n      <div class="global-stat">\n        <span class="global-stat-value">${Math.round(globalInsights.avg_songs_per_user||0).toLocaleString()}</span>\n        <span class="global-stat-label">Avg per User</span>\n      </div>\n    </div>\n    ${e}\n    ${n}\n    ${s}\n    <p class="insights-timestamp">Last updated: ${new Date(globalInsights.computed_at).toLocaleDateString()}</p>\n  `}function renderPercentileBadge(){if(!globalInsights?.song_count_percentiles)return"";const t=cachedUserStats?.totalSongs||0;if(0===t)return"";const e=analytics.calculatePercentile(t,globalInsights.song_count_percentiles),n=globalInsights.avg_songs_per_user||0;let s="bronze",a="🥉",o="Creator";return e<=1?(s="legendary",a="👑",o="Legendary Creator"):e<=5?(s="diamond",a="💎",o="Diamond Creator"):e<=10?(s="gold",a="🥇",o="Gold Creator"):e<=25&&(s="silver",a="🥈",o="Silver Creator"),`\n    <div class="percentile-badge ${s}">\n      <div class="badge-header">\n        <span class="badge-emoji">${a}</span>\n        <span class="badge-title">${o}</span>\n      </div>\n      <div class="badge-stats">\n        <div class="badge-stat">\n          <span class="stat-value">Top ${e}%</span>\n          <span class="stat-label">of all creators</span>\n        </div>\n        <div class="badge-stat">\n          <span class="stat-value">${n>0?(t/n).toFixed(1):0}x</span>\n          <span class="stat-label">avg library size</span>\n        </div>\n      </div>\n    </div>\n  `}function renderGenreComparison(){if(!globalInsights?.genre_distribution)return"";const t=Object.entries(globalInsights.genre_distribution).slice(0,5).map(([t,e])=>`\n      <div class="comparison-bar">\n        <span class="comparison-label">${t}</span>\n        <div class="comparison-track">\n          <div class="comparison-fill" style="width: ${e}%"></div>\n        </div>\n        <span class="comparison-value">${e}%</span>\n      </div>\n    `).join("");return t?`\n    <div class="comparison-section">\n      <h4>🎵 Top Genres (Community)</h4>\n      ${t}\n    </div>\n  `:""}function renderModelComparison(){if(!globalInsights?.model_distribution)return"";const t=Object.entries(globalInsights.model_distribution).slice(0,5).map(([t,e])=>`\n      <div class="comparison-bar">\n        <span class="comparison-label">${t}</span>\n        <div class="comparison-track">\n          <div class="comparison-fill model" style="width: ${e}%"></div>\n        </div>\n        <span class="comparison-value">${e}%</span>\n      </div>\n    `).join("");return t?`\n    <div class="comparison-section">\n      <h4>🤖 Model Usage (Community)</h4>\n      ${t}\n    </div>\n  `:""}async function submitAnalytics(){if(!analytics)return void showToast("Analytics not initialized","error");if(0===settings.privacyTier)return void showToast("Privacy set to Ghost Mode - not submitting","info");const t=document.getElementById("btnSubmitAnalytics");t&&(t.disabled=!0,t.textContent="📤 Submitting...");try{const t=await gatherAnalyticsStats(),e=await analytics.submitAnalytics(t,settings.privacyTier);e.success?(settings.lastAnalyticsSubmit=(new Date).toISOString(),await saveSettings(),e.alreadySubmitted?showToast("Already submitted today!","info"):showToast("Analytics submitted! Thank you 🎉","success"),await fetchGlobalInsights()):showToast("Submission failed: "+e.error,"error")}catch(t){showToast("Submission failed: "+t.message,"error")}finally{t&&(t.disabled=!1,t.textContent="📤 Submit Analytics")}}async function gatherAnalyticsStats(){const t=await SunoOfflineDB.getAllClips(),e=t.length,n=t.filter(t=>t.is_liked).length;let s=0;t.forEach(t=>{s+=t.metadata?.duration||0});const a=Math.round(s/3600*10)/10,o={};t.forEach(t=>{const e=t.title?.toLowerCase().trim()||"untitled";o[e]=(o[e]||0)+1});const i=Object.keys(o).length,r={};t.forEach(t=>{(t.metadata?.tags||"").split(",").forEach(t=>{const e=t.trim().toLowerCase();e&&e.length>1&&(r[e]=(r[e]||0)+1)})});const l=Object.entries(r).sort((t,e)=>e[1]-t[1]).slice(0,20),c=Object.fromEntries(l),d={};t.forEach(t=>{const e=SunoOfflineDB.getModelLabel(t);d[e]=(d[e]||0)+1});const u={};return t.forEach(t=>{const e=t.created_at?new Date(t.created_at):null;if(e){const t=`${e.getFullYear()}-${String(e.getMonth()+1).padStart(2,"0")}`;u[t]=(u[t]||0)+1}}),{userId:await getUserId(),totalSongs:e,likedSongs:n,totalDurationHours:a,uniqueSongGroups:i,genreCounts:c,modelCounts:d,creationByMonth:u}}async function getUserId(){try{const t=await chrome.runtime.sendMessage({action:"getToken"});if(t?.token){const e=t.token.split(".");if(3===e.length){const t=JSON.parse(atob(e[1]));return t.sub||t["https://suno.ai/claims/clerk_id"]||"unknown"}}}catch(t){}return"unknown"}function formatNumber(t){return t>=1e6?(t/1e6).toFixed(1)+"M":t>=1e3?(t/1e3).toFixed(1)+"K":t.toLocaleString()}async function loadAboutInfo(){try{const t=chrome.runtime.getManifest();document.getElementById("appVersion").textContent=t.version||"1.0.0";const e=await SunoOfflineDB.getClipCount();if(document.getElementById("librarySize").textContent=`${e.toLocaleString()} songs`,navigator.storage&&navigator.storage.estimate){const t=await navigator.storage.estimate(),e=Math.round(t.usage/1024/1024);document.getElementById("storageUsed").textContent=`~${e} MB`}if(settings.lastAnalyticsSubmit){const t=document.getElementById("lastAnalyticsSubmit");t&&(t.textContent=new Date(settings.lastAnalyticsSubmit).toLocaleDateString())}}catch(t){}}function formatTime(t){return new Date(t).toLocaleString()}function escapeHtml(t){const e=document.createElement("div");return e.textContent=t,e.innerHTML}function showToast(t,e="info"){const n=document.getElementById("toast");n.textContent=t,n.className=`toast show ${e}`,setTimeout(()=>{n.classList.remove("show")},3e3)}async function logError(t){if(!settings.errorReporting)return;const e={time:(new Date).toISOString(),message:t.message||"Unknown error",source:t.source,line:t.line,stack:t.stack};errorLog.unshift(e),errorLog=errorLog.slice(0,50);try{await chrome.storage.local.set({[ERROR_LOG_KEY]:errorLog}),renderErrorLog()}catch(t){}}async function init(){await loadSettings(),await loadAboutInfo(),await initAnalytics(),document.getElementById("btnSubmitAnalytics")?.addEventListener("click",submitAnalytics),document.getElementById("btnRefreshInsights")?.addEventListener("click",async()=>{showToast("Refreshing...","info"),await fetchGlobalInsights(),showToast("Insights updated!","success")})}document.getElementById("btnExportPublic")?.addEventListener("click",async()=>{try{if(publicExportData||await updatePublicExportStats(),!publicExportData||0===publicExportData.clips.length)return void showToast("No public songs to export! Mark some songs as public first.","warning");const t=await SunoOfflineDB.getUserPrefs(),e={meta:{exportedAt:(new Date).toISOString(),version:"1.0.0",songCount:publicExportData.songCount,versionCount:publicExportData.versionCount,generator:"Suno Explorer"},config:{mode:"public-site",showCurationTools:!1,showPrivateSongs:!1},customNames:publicExportData.customNames,definitiveVersions:t.definitiveVersions||{},manualLinks:publicExportData.manualLinks||{},clips:publicExportData.clips.map(t=>({id:t.id,title:t.title,created_at:t.created_at,audio_url:t.audio_url,image_url:t.image_url,video_url:t.video_url,metadata:{tags:t.metadata?.tags,prompt:t.metadata?.prompt,duration:t.metadata?.duration,type:t.metadata?.type,has_vocal:t.metadata?.has_vocal,gpt_description_prompt:t.metadata?.gpt_description_prompt},major_model_version:t.major_model_version,model_name:t.model_name,parent_id:publicExportData.manualLinks[t.id]||SunoOfflineDB.getParentId(t)||null,is_liked:t.is_liked,play_count:t.play_count,externalLinks:t.externalLinks||[],releaseStatus:t.releaseStatus||"unreleased",_lineageOnly:t._lineageOnly||!1}))},n=new Blob([JSON.stringify(e,null,2)],{type:"application/json"}),s=URL.createObjectURL(n),a=document.createElement("a");a.href=s,a.download=`public-library-${(new Date).toISOString().split("T")[0]}.json`,document.body.appendChild(a),a.click(),document.body.removeChild(a),URL.revokeObjectURL(s),showToast(`Exported ${publicExportData.songCount} songs for your portfolio!`,"success")}catch(t){showToast("Export failed: "+t.message,"error")}}),document.getElementById("btnPreviewPublic")?.addEventListener("click",async()=>{try{if(publicExportData||await updatePublicExportStats(),!publicExportData||0===publicExportData.clips.length)return void showToast("No public songs to preview!","warning");showPublicPreviewModal(publicExportData)}catch(t){showToast("Preview failed: "+t.message,"error")}}),initPublicExport(),document.getElementById("btnClearAll")?.addEventListener("click",async()=>{if(confirm("⚠️ This will permanently delete ALL data:\n\n• Library index (all song metadata)\n• Custom names\n• Definitive version settings\n• Download history\n• Settings\n\nThis cannot be undone. Continue?")&&confirm('Are you absolutely sure? Type "DELETE" in the next prompt to confirm.'))if("DELETE"===prompt("Type DELETE to confirm:"))try{indexedDB.deleteDatabase("SunoOfflineDB").onsuccess=()=>{},await chrome.storage.local.clear(),showToast("All data cleared","success"),setTimeout(()=>location.reload(),1500)}catch(t){showToast("Clear failed: "+t.message,"error")}else showToast("Deletion cancelled","error")}),window.onerror=function(t,e,n,s,a){logError({message:t,source:e,line:n,col:s,stack:a?.stack})},window.onunhandledrejection=function(t){logError({message:t.reason?.message||"Unhandled promise rejection",stack:t.reason?.stack})},window.SunoOfflineError={log:logError,getSettings:()=>settings},init();