const ShareCard={themes:{midnight:{name:"Midnight",bg:["#0f0f23","#1a1a2e","#16213e"],accent:"#a855f7",accentAlt:"#ec4899",text:"#ffffff",textMuted:"#a1a1aa",glow:"rgba(168, 85, 247, 0.3)"},aurora:{name:"Aurora",bg:["#0d1b2a","#1b263b","#415a77"],accent:"#22c55e",accentAlt:"#14b8a6",text:"#ffffff",textMuted:"#94a3b8",glow:"rgba(34, 197, 94, 0.3)"},sunset:{name:"Sunset",bg:["#1a1a2e","#2d1b4e","#4a1942"],accent:"#f59e0b",accentAlt:"#ef4444",text:"#ffffff",textMuted:"#d4d4d8",glow:"rgba(245, 158, 11, 0.3)"},ocean:{name:"Ocean",bg:["#0c1821","#1b2838","#2a4858"],accent:"#0ea5e9",accentAlt:"#6366f1",text:"#ffffff",textMuted:"#94a3b8",glow:"rgba(14, 165, 233, 0.3)"}},variants:{full:{name:"Full Stats",height:1500,icon:"📊"},compact:{name:"Compact",height:600,icon:"📱"},"badge-only":{name:"Badge Only",height:600,icon:"🏆"},"night-owl":{name:"Night Owl",height:700,icon:"🦉"},"genre-dna":{name:"Genre DNA",height:800,icon:"🧬"},perfectionist:{name:"Perfectionist",height:700,icon:"🔄"},marathon:{name:"Marathon Maker",height:700,icon:"⏱️"},timeline:{name:"Timeline",height:800,icon:"📅"},"model-mix":{name:"Model Mix",height:700,icon:"🤖"}},async generateCard(t,e={}){const{theme:l="midnight",variant:a="full",width:n=1080}=e,i=(this.variants[a]||this.variants.full).height,o=document.createElement("canvas");o.width=n,o.height=i;const s=o.getContext("2d"),r=this.themes[l]||this.themes.midnight,f=s.createLinearGradient(0,0,n,i);switch(r.bg.forEach((t,e)=>f.addColorStop(e/(r.bg.length-1),t)),s.fillStyle=f,s.fillRect(0,0,n,i),this.addNoiseTexture(s,n,i,.03),this.addGlowOrb(s,.2*n,.3*i,200,r.accent),this.addGlowOrb(s,.8*n,.7*i,250,r.accentAlt),a){case"badge-only":await this.drawBadgeOnly(s,t,r,n,i);break;case"compact":await this.drawCompact(s,t,r,n,i);break;case"night-owl":await this.drawNightOwl(s,t,r,n,i);break;case"genre-dna":await this.drawGenreDNA(s,t,r,n,i);break;case"perfectionist":await this.drawPerfectionist(s,t,r,n,i);break;case"marathon":await this.drawMarathon(s,t,r,n,i);break;case"timeline":await this.drawTimeline(s,t,r,n,i);break;case"model-mix":await this.drawModelMix(s,t,r,n,i);break;default:await this.drawFull(s,t,r,n,i)}return this.drawFooter(s,r,n,i),o},async drawFull(t,e,l,a,n){let i=80;t.font="64px sans-serif",t.textAlign="center",t.fillText("🎵",a/2,i+50),i+=120,t.fillStyle=l.text,t.font='bold 48px "Space Grotesk", sans-serif',t.fillText("My Suno Wrapped",a/2,i),i+=50,t.font='24px "Space Grotesk", sans-serif',t.fillStyle=l.textMuted,t.fillText((new Date).getFullYear().toString(),a/2,i),i+=80;let o=(a-1e3)/2;[{value:this.formatNumber(e.totalSongs),label:"Songs Created",emoji:"🎼"},{value:this.formatNumber(e.likedSongs),label:"Favorites",emoji:"❤️"},{value:this.formatDuration(e.totalDurationHours),label:"Of Music",emoji:"⏱️"}].forEach((e,a)=>{this.drawStatBox(t,o+350*a,i,300,160,e,l)}),i+=240;const s=this.getBadgeInfo(e);if(this.drawBadgeSection(t,a/2,i,s,l),i+=240,e.topGenres&&e.topGenres.length>0){t.fillStyle=l.text,t.font='bold 32px "Space Grotesk", sans-serif',t.textAlign="center",t.fillText("🎸 Your Sound",a/2,i),i+=70;const n=e.topGenres.slice(0,4),o=20,s=60,r=a-100-(n.length-1)*o,f=Math.min(180,r/n.length);let c=(a-(n.length*f+(n.length-1)*o))/2;n.forEach((e,a)=>{this.drawGenrePill(t,c+a*(f+o),i,f,s,e,l,a)}),i+=s+80}if(e.modelCounts){t.fillStyle=l.text,t.font='bold 32px "Space Grotesk", sans-serif',t.textAlign="center",t.fillText("🤖 AI Models Used",a/2,i),i+=70;const n=Object.entries(e.modelCounts).sort((t,e)=>e[1]-t[1]).slice(0,4),o=220,s=30;let r=(a-(n.length*o+(n.length-1)*s))/2;const f=Math.max(...n.map(t=>t[1]));n.forEach(([e,a],n)=>{this.drawModelBar(t,r+n*(o+s),i,o,100,e,a,f,l)}),i+=160}e.funFact&&(t.fillStyle=l.textMuted,t.font='italic 24px "Space Grotesk", sans-serif',t.textAlign="center",t.fillText(`"${e.funFact}"`,a/2,i+60))},async drawCompact(t,e,l,a,n){let i=80;t.fillStyle=l.text,t.font='bold 32px "Space Grotesk", sans-serif',t.textAlign="center",t.fillText("My Suno Wrapped",a/2,i),i+=70;let o=(a-590)/2;[{value:this.formatNumber(e.totalSongs),label:"Songs",emoji:"🎼"},{value:this.formatNumber(e.likedSongs),label:"Favorites",emoji:"❤️"},{value:this.formatDuration(e.totalDurationHours),label:"Hours",emoji:"⏱️"}].forEach((e,a)=>{this.drawStatBox(t,o+205*a,i,180,90,e,l,!0)}),i+=140;const s=this.getBadgeInfo(e);if(this.drawBadgeSection(t,a/2,i,s,l,.7),i+=150,e.topGenres&&e.topGenres.length>0){t.fillStyle=l.textMuted,t.font='16px "Space Grotesk", sans-serif',t.textAlign="center";const n=e.topGenres.slice(0,3).map(t=>t.name).join(" • ");t.fillText(`Top genres: ${n}`,a/2,i)}},async drawBadgeOnly(t,e,l,a,n){const i=this.getBadgeInfo(e);this.drawBadgeSection(t,a/2,n/2-120,i,l,1.5),t.fillStyle=l.textMuted,t.font='24px "Space Grotesk", sans-serif',t.textAlign="center",t.fillText(`${this.formatNumber(e.totalSongs)} songs created`,a/2,n/2+150)},async drawNightOwl(t,e,l,a,n){let i=80;t.font="56px sans-serif",t.textAlign="center",t.fillText(e.peakHour>=22||e.peakHour<6?"🦉":"☀️",a/2,i+40),i+=100,t.fillStyle=l.text,t.font='bold 42px "Space Grotesk", sans-serif';const o=e.peakHour>=22||e.peakHour<6;t.fillText(o?"Night Owl":"Early Bird",a/2,i),i+=50,t.fillStyle=l.textMuted,t.font='24px "Space Grotesk", sans-serif',t.fillText("Your peak creative hours",a/2,i),i+=80;const s=e.peakHour||22,r=s>12?s-12+" PM":`${s} AM`;t.fillStyle=l.accent,t.font='bold 72px "Space Grotesk", sans-serif',t.fillText(r,a/2,i),i+=50,t.fillStyle=l.textMuted,t.font='20px "Space Grotesk", sans-serif',t.fillText("is when the magic happens",a/2,i),i+=100;const f=e.lateNightCount||Math.floor(.3*e.totalSongs);t.fillStyle=l.text,t.font='28px "Space Grotesk", sans-serif',t.fillText(`${this.formatNumber(f)} songs created after midnight`,a/2,i)},async drawGenreDNA(t,e,l,a,n){let i=80;t.font="56px sans-serif",t.textAlign="center",t.fillText("🧬",a/2,i+40),i+=100,t.fillStyle=l.text,t.font='bold 42px "Space Grotesk", sans-serif',t.fillText("Your Genre DNA",a/2,i),i+=50,t.fillStyle=l.textMuted,t.font='24px "Space Grotesk", sans-serif',t.fillText("Your unique musical fingerprint",a/2,i),i+=80;const o=(e.topGenres||[]).slice(0,5),s=o[0]?.count||1,r=a-200;o.forEach((e,n)=>{const o=[l.accent,l.accentAlt,"#22c55e","#0ea5e9","#f59e0b"],f=o[n%o.length],c=e.count/s*r;t.fillStyle="rgba(255,255,255,0.05)",this.roundRect(t,100,i,r,60,10),t.fill(),t.fillStyle=f,this.roundRect(t,100,i,c,60,10),t.fill(),t.fillStyle=l.text,t.font='bold 20px "Space Grotesk", sans-serif',t.textAlign="left",t.fillText(e.name,120,i+38),t.fillStyle=l.textMuted,t.textAlign="right",t.font='18px "Space Grotesk", sans-serif',t.fillText(`${e.count} songs`,a-120,i+38),i+=80}),t.textAlign="center"},async drawPerfectionist(t,e,l,a,n){let i=80;t.font="56px sans-serif",t.textAlign="center",t.fillText("🔄",a/2,i+40),i+=100,t.fillStyle=l.text,t.font='bold 42px "Space Grotesk", sans-serif',t.fillText("The Perfectionist",a/2,i),i+=50,t.fillStyle=l.textMuted,t.font='24px "Space Grotesk", sans-serif',t.fillText("Your dedication to getting it just right",a/2,i),i+=80;const o=e.mostVersionedCount||42;t.fillStyle=l.accent,t.font='bold 96px "Space Grotesk", sans-serif',t.fillText(o.toString(),a/2,i),i+=40,t.fillStyle=l.text,t.font='24px "Space Grotesk", sans-serif',t.fillText("versions of one song",a/2,i),i+=80;const s=e.mostVersionedSong||"Untitled";t.fillStyle=l.textMuted,t.font='italic 20px "Space Grotesk", sans-serif',t.fillText(`"${s}"`,a/2,i),i+=60;const r=e.totalVersions||e.totalSongs;t.fillStyle=l.text,t.font='22px "Space Grotesk", sans-serif',t.fillText(`${this.formatNumber(r)} total versions across all songs`,a/2,i)},async drawMarathon(t,e,l,a,n){let i=80;t.font="56px sans-serif",t.textAlign="center",t.fillText("⏱️",a/2,i+40),i+=100,t.fillStyle=l.text,t.font='bold 42px "Space Grotesk", sans-serif',t.fillText("Marathon Maker",a/2,i),i+=50,t.fillStyle=l.textMuted,t.font='24px "Space Grotesk", sans-serif',t.fillText("Your epic-length creations",a/2,i),i+=80;const o=Math.floor((e.longestDuration||480)/60),s=Math.round((e.longestDuration||480)%60);t.fillStyle=l.accent,t.font='bold 72px "Space Grotesk", sans-serif',t.fillText(`${o}:${s.toString().padStart(2,"0")}`,a/2,i),i+=40,t.fillStyle=l.text,t.font='24px "Space Grotesk", sans-serif',t.fillText("longest song",a/2,i),i+=80;const r=e.longestSong||"Epic Journey";t.fillStyle=l.textMuted,t.font='italic 20px "Space Grotesk", sans-serif',t.fillText(`"${r}"`,a/2,i),i+=60,t.fillStyle=l.text,t.font='22px "Space Grotesk", sans-serif',t.fillText(`${this.formatDuration(e.totalDurationHours)} of music total`,a/2,i)},async drawTimeline(t,e,l,a,n){let i=80;t.font="56px sans-serif",t.textAlign="center",t.fillText("📅",a/2,i+40),i+=100,t.fillStyle=l.text,t.font='bold 42px "Space Grotesk", sans-serif',t.fillText("Your Creative Journey",a/2,i),i+=50,t.fillStyle=l.textMuted,t.font='24px "Space Grotesk", sans-serif',t.fillText((new Date).getFullYear().toString(),a/2,i),i+=80;const o=e.monthlyBreakdown||Array(12).fill(0).map(()=>Math.floor(100*Math.random())),s=Math.max(...o,1);let r=(a-940)/2;const f=["J","F","M","A","M","J","J","A","S","O","N","D"];o.forEach((e,a)=>{const n=e/s*200,o=r+80*a;t.fillStyle=e===s?l.accent:l.accent+"60",this.roundRect(t,o,i+200-n,60,n,6),t.fill(),t.fillStyle=l.textMuted,t.font='14px "Space Grotesk", sans-serif',t.textAlign="center",t.fillText(f[a],o+30,i+200+25)}),i+=280;const c=o.indexOf(Math.max(...o));t.fillStyle=l.text,t.font='22px "Space Grotesk", sans-serif',t.textAlign="center",t.fillText(`Most creative in ${["January","February","March","April","May","June","July","August","September","October","November","December"][c]}`,a/2,i)},async drawModelMix(t,e,l,a,n){let i=80;t.font="56px sans-serif",t.textAlign="center",t.fillText("🤖",a/2,i+40),i+=100,t.fillStyle=l.text,t.font='bold 42px "Space Grotesk", sans-serif',t.fillText("Your AI Mix",a/2,i),i+=50,t.fillStyle=l.textMuted,t.font='24px "Space Grotesk", sans-serif',t.fillText("Models that powered your music",a/2,i),i+=80;const o=Object.entries(e.modelCounts||{}).sort((t,e)=>e[1]-t[1]).slice(0,5),s=o.reduce((t,[e,l])=>t+l,0)||1,r=[l.accent,l.accentAlt,"#22c55e","#0ea5e9","#f59e0b"],f=a/2,c=i+100;let d=-Math.PI/2;o.forEach(([e,l],a)=>{const n=l/s*Math.PI*2;t.fillStyle=r[a%r.length],t.beginPath(),t.moveTo(f,c),t.arc(f,c,100,d,d+n),t.closePath(),t.fill(),d+=n}),i+=250;const x=200*o.length+30*(o.length-1);let h=Math.max(50,(a-Math.min(x,a-100))/2);t.font='16px "Space Grotesk", sans-serif',o.forEach(([e,a],n)=>{const o=Math.round(a/s*100);t.fillStyle=r[n%r.length],t.beginPath(),t.arc(h,i,8,0,2*Math.PI),t.fill(),t.fillStyle=l.text,t.textAlign="left",t.fillText(`${e} (${o}%)`,h+20,i+5),h+=200}),t.textAlign="center"},drawStatBox(t,e,l,a,n,i,o,s=!1){t.fillStyle="rgba(255, 255, 255, 0.05)",this.roundRect(t,e,l,a,n,16),t.fill(),t.strokeStyle="rgba(255, 255, 255, 0.1)",t.lineWidth=1,this.roundRect(t,e,l,a,n,16),t.stroke(),t.globalAlpha=1,t.fillStyle=o.text,t.font=s?"24px sans-serif":"32px sans-serif",t.textAlign="center",t.fillText(i.emoji,e+a/2,l+(s?32:42)),t.fillStyle=o.text,t.font=`bold ${s?"28px":"36px"} "Space Grotesk", sans-serif`,t.fillText(i.value,e+a/2,l+(s?62:80)),t.fillStyle=o.textMuted,t.font=(s?"12px":"14px")+' "Space Grotesk", sans-serif',t.fillText(i.label,e+a/2,l+(s?80:100))},drawBadgeSection(t,e,l,a,n,i=1){const o=72*i,s=32*i,r=18*i;t.shadowColor=n.glow,t.shadowBlur=40*i,t.fillStyle=n.accent,t.beginPath(),t.arc(e,l,60*i,0,2*Math.PI),t.fill(),t.shadowBlur=0,t.font=`${o}px sans-serif`,t.textAlign="center",t.fillText(a.emoji,e,l+25*i),t.fillStyle=n.text,t.font=`bold ${s}px "Space Grotesk", sans-serif`,t.fillText(a.title,e,l+100*i),t.fillStyle=n.accent,t.font=`${r}px "Space Grotesk", sans-serif`,t.fillText(a.subtitle,e,l+140*i)},drawGenrePill(t,e,l,a,n,i,o,s){const r=[o.accent,o.accentAlt,"#22c55e","#0ea5e9","#f59e0b"],f=r[s%r.length];t.fillStyle=f+"33",this.roundRect(t,e,l,a,n,n/2),t.fill(),t.strokeStyle=f,t.lineWidth=2,this.roundRect(t,e,l,a,n,n/2),t.stroke(),t.fillStyle=o.text,t.font='bold 16px "Space Grotesk", sans-serif',t.textAlign="center",t.fillText(i.name,e+a/2,l+n/2-5),t.fillStyle=o.textMuted,t.font='12px "Space Grotesk", sans-serif',t.fillText(`${i.count} songs`,e+a/2,l+n/2+15)},drawModelBar(t,e,l,a,n,i,o,s,r){const f=o/s*(a-20);t.fillStyle=r.text,t.font='bold 16px "Space Grotesk", sans-serif',t.textAlign="center",t.fillText(i,e+a/2,l+20),t.fillStyle="rgba(255, 255, 255, 0.1)",this.roundRect(t,e+10,l+35,a-20,12,6),t.fill();const c=t.createLinearGradient(e+10,l+35,e+10+f,l+35);c.addColorStop(0,r.accent),c.addColorStop(1,r.accentAlt),t.fillStyle=c,this.roundRect(t,e+10,l+35,f,12,6),t.fill(),t.fillStyle=r.textMuted,t.font='14px "Space Grotesk", sans-serif',t.fillText(this.formatNumber(o),e+a/2,l+65)},drawFooter(t,e,l,a){t.fillStyle=e.textMuted,t.font='16px "Space Grotesk", sans-serif',t.textAlign="center",t.fillText("Generated with Suno Explorer",l/2,a-30)},addNoiseTexture(t,e,l,a){const n=t.getImageData(0,0,e,l),i=n.data;for(let t=0;t<i.length;t+=4){const e=255*(Math.random()-.5)*a;i[t]+=e,i[t+1]+=e,i[t+2]+=e}t.putImageData(n,0,0)},addGlowOrb(t,e,l,a,n){const i=t.createRadialGradient(e,l,0,e,l,a);i.addColorStop(0,n+"40"),i.addColorStop(1,n+"00"),t.fillStyle=i,t.beginPath(),t.arc(e,l,a,0,2*Math.PI),t.fill()},roundRect(t,e,l,a,n,i){t.beginPath(),t.moveTo(e+i,l),t.lineTo(e+a-i,l),t.quadraticCurveTo(e+a,l,e+a,l+i),t.lineTo(e+a,l+n-i),t.quadraticCurveTo(e+a,l+n,e+a-i,l+n),t.lineTo(e+i,l+n),t.quadraticCurveTo(e,l+n,e,l+n-i),t.lineTo(e,l+i),t.quadraticCurveTo(e,l,e+i,l),t.closePath()},getBadgeInfo(t){const e=t.totalSongs||0;return e>=1e4?{emoji:"👑",title:"Legendary Creator",subtitle:`Top 1% • ${this.formatNumber(e)} songs`}:e>=5e3?{emoji:"💎",title:"Diamond Creator",subtitle:`Top 5% • ${this.formatNumber(e)} songs`}:e>=1e3?{emoji:"🥇",title:"Gold Creator",subtitle:`Top 10% • ${this.formatNumber(e)} songs`}:e>=500?{emoji:"🥈",title:"Silver Creator",subtitle:`Top 25% • ${this.formatNumber(e)} songs`}:e>=100?{emoji:"🥉",title:"Bronze Creator",subtitle:`${this.formatNumber(e)} songs`}:{emoji:"🎵",title:"Creator",subtitle:`${this.formatNumber(e)} songs`}},formatNumber:t=>t>=1e6?(t/1e6).toFixed(1)+"M":t>=1e3?(t/1e3).toFixed(1)+"K":t.toLocaleString(),formatDuration:t=>t>=24?Math.round(t/24)+" days":Math.round(t)+"h",async download(t,e="suno-wrapped.png"){const l=document.createElement("a");l.download=e,l.href=t.toDataURL("image/png"),l.click()},async share(t,e="My Suno Wrapped"){if(navigator.share&&navigator.canShare)try{const l=await new Promise(e=>t.toBlob(e,"image/png")),a=new File([l],"suno-wrapped.png",{type:"image/png"});if(navigator.canShare({files:[a]}))return await navigator.share({title:e,text:"Check out my Suno music creation stats! 🎵",files:[a]}),!0}catch(t){}return this.download(t),!1}};"undefined"!=typeof window&&(window.ShareCard=ShareCard);