const LineageExplorer={clips:[],lineageMap:null,selectedUpload:null,showLikedOnly:!1,showThumbnails:!0,init(e){this.clips=e,this.lineageMap=SunoOfflineDB.buildLineageMap(e),this.renderUploadsList()},renderUploadsList(){const e=document.getElementById("uploadsGrid");if(!e)return;const n=this.clips.filter(e=>"upload"===SunoOfflineDB.getClipType(e)).map(e=>{const n=this.getDescendantCount(e.id);return{...e,descendantCount:n}}).sort((e,n)=>n.descendantCount-e.descendantCount);if(0===n.length)return void(e.innerHTML='\n        <div class="lineage-empty">\n          <span class="lineage-empty-icon">📤</span>\n          <p>No uploads found in your library</p>\n          <p class="muted">Upload audio to Suno to start a lineage tree</p>\n        </div>\n      ');const t=n.length,a=n.reduce((e,n)=>e+n.descendantCount,0),s=Math.round(a/t*10)/10,l=Math.max(...n.map(e=>e.descendantCount));document.getElementById("uploadStats").innerHTML=`\n      <div class="upload-stat">\n        <span class="stat-value">${t}</span>\n        <span class="stat-label">Uploads</span>\n      </div>\n      <div class="upload-stat">\n        <span class="stat-value">${a}</span>\n        <span class="stat-label">Total Variations</span>\n      </div>\n      <div class="upload-stat">\n        <span class="stat-value">${s}</span>\n        <span class="stat-label">Avg per Upload</span>\n      </div>\n      <div class="upload-stat">\n        <span class="stat-value">${l}</span>\n        <span class="stat-label">Most Prolific</span>\n      </div>\n    `,e.innerHTML=n.slice(0,20).map(e=>this.renderUploadCard(e)).join(""),e.querySelectorAll(".upload-card").forEach(e=>{e.addEventListener("click",()=>{const n=e.dataset.id;this.showLineageTree(n)})})},renderUploadCard(e){const n=e.title||"Untitled Upload",t=e.image_url||"../icons/icon128.png",a=this.formatDuration(e.metadata?.duration||0),s=e.created_at?new Date(e.created_at).toLocaleDateString():"";return`\n      <div class="upload-card" data-id="${e.id}">\n        <div class="upload-thumbnail">\n          <img src="${t}" alt="${this.escapeHtml(n)}" loading="lazy">\n          <span class="upload-badge">${e.descendantCount} variations</span>\n        </div>\n        <div class="upload-info">\n          <h4 class="upload-title">${this.escapeHtml(n)}</h4>\n          <div class="upload-meta">\n            <span>${a}</span>\n            <span>${s}</span>\n          </div>\n        </div>\n      </div>\n    `},showLineageTree(e){const n=this.clips.find(n=>n.id===e);if(!n)return;this.selectedUpload=n;const t=this.buildTreeData(e);this.showTreeModal(n,t)},buildTreeData(e,n=0,t=10){if(n>t)return null;const a=this.clips.find(n=>n.id===e);if(!a)return null;const s=this.lineageMap.parentToChildren.get(e)||[];return{id:a.id,title:a.title||"Untitled",type:SunoOfflineDB.getClipType(a),isLiked:a.is_liked,isInstrumental:SunoOfflineDB.isInstrumental(a),thumbnail:a.image_url,duration:a.metadata?.duration,model:SunoOfflineDB.getModelLabel(a),children:s.map(e=>this.buildTreeData(e,n+1,t)).filter(Boolean)}},showTreeModal(e,n){const t=document.getElementById("lineageModal");t&&t.remove();const a=this.showLikedOnly?this.filterLikedNodes(n):n,s=this.countNodes(a),l=this.getMaxDepth(a),i=this.showLikedOnly?this.countNodes(n)-s:0,d=document.createElement("div");d.id="lineageModal",d.className="lineage-modal",d.innerHTML=`\n      <div class="lineage-modal-content">\n        <div class="lineage-modal-header">\n          <div class="lineage-modal-title">\n            <h2>🌳 Lineage Tree</h2>\n            <p class="lineage-root-name">${this.escapeHtml(e.title||"Untitled Upload")}</p>\n          </div>\n          <div class="lineage-modal-filters">\n            <button class="lineage-filter-btn ${this.showLikedOnly?"active":""}" id="lineageLikedFilter" title="Show only liked versions">\n              ❤️ Liked Only\n            </button>\n            <button class="lineage-filter-btn ${this.showThumbnails?"active":""}" id="lineageThumbToggle" title="Show/hide thumbnails">\n              🖼️ Thumbnails\n            </button>\n          </div>\n          <div class="lineage-modal-stats">\n            <span class="lineage-stat">${s} clips</span>\n            <span class="lineage-stat">${l} generations</span>\n            ${i>0?`<span class="lineage-stat muted">${i} hidden</span>`:""}\n          </div>\n          <button class="lineage-close" id="closeLineageModal">✕</button>\n        </div>\n        <div class="lineage-tree-container ${this.showThumbnails?"show-thumbnails":""}" id="lineageTreeContainer">\n          ${a?this.renderTree(a):'<p class="lineage-empty">No liked songs in this lineage</p>'}\n        </div>\n        <div class="lineage-legend">\n          <span class="legend-item"><span class="legend-dot upload"></span> Upload</span>\n          <span class="legend-item"><span class="legend-dot extend"></span> Extend</span>\n          <span class="legend-item"><span class="legend-dot edit"></span> Edit/Remix</span>\n          <span class="legend-item"><span class="legend-dot cover"></span> Cover</span>\n          <span class="legend-item"><span class="legend-dot other"></span> Other</span>\n        </div>\n      </div>\n    `,document.body.appendChild(d),document.getElementById("closeLineageModal").addEventListener("click",()=>d.remove()),d.addEventListener("click",e=>{e.target===d&&d.remove()}),document.getElementById("lineageLikedFilter").addEventListener("click",()=>{this.showLikedOnly=!this.showLikedOnly,this.showTreeModal(e,n)}),document.getElementById("lineageThumbToggle").addEventListener("click",()=>{this.showThumbnails=!this.showThumbnails,this.showTreeModal(e,n)}),d.querySelectorAll(".tree-node").forEach(e=>{e.addEventListener("click",n=>{n.stopPropagation();const t=e.dataset.id;this.playClip(t)})})},filterLikedNodes(e){if(!e)return null;const n=e.children.map(e=>this.filterLikedNodes(e)).filter(Boolean);return e.isLiked||n.length>0?{...e,children:n}:null},renderTree(e,n=!0,t=""){if(!e)return"";const a=this.getTypeClass(e.type),s=e.isLiked?"❤️":"",l=e.isInstrumental?"🎸":"",i=e.thumbnail?`<img class="node-thumb" src="${e.thumbnail}" alt="" loading="lazy">`:'<div class="node-thumb-placeholder">🎵</div>';let d=`\n      <div class="tree-row">\n        <span class="tree-branch">${t}${n?"└─":"├─"}</span>\n        <div class="tree-node ${a}" data-id="${e.id}" title="Click to play">\n          <span class="node-thumb-wrap">${i}</span>\n          <span class="node-type-dot"></span>\n          <span class="node-title">${this.escapeHtml(e.title)}</span>\n          <span class="node-badges">${s}${l}</span>\n          <span class="node-model">${e.model}</span>\n        </div>\n      </div>\n    `;if(e.children&&e.children.length>0){const a=t+(n?"   ":"│  ");e.children.forEach((n,t)=>{const s=t===e.children.length-1;d+=this.renderTree(n,s,a)})}return d},getTypeClass(e){switch(e){case"upload":return"type-upload";case"extend":return"type-extend";case"edit":return"type-edit";case"remix":return"type-remix";case"cover":return"type-cover";case"upsample":return"type-upsample";default:return"type-other"}},countNodes(e){return e?1+(e.children||[]).reduce((e,n)=>e+this.countNodes(n),0):0},getMaxDepth(e,n=0){return e&&e.children&&0!==e.children.length?Math.max(...e.children.map(e=>this.getMaxDepth(e,n+1))):n},getDescendantCount(e){return SunoOfflineDB.getDescendants(e,this.lineageMap.parentToChildren).length},playClip(e){const n=this.clips.find(n=>n.id===e);n&&n.audio_url&&"function"==typeof playClip&&playClip(n)},formatDuration:e=>e?`${Math.floor(e/60)}:${Math.floor(e%60).toString().padStart(2,"0")}`:"0:00",escapeHtml(e){const n=document.createElement("div");return n.textContent=e||"",n.innerHTML}};"undefined"!=typeof window&&(window.LineageExplorer=LineageExplorer);