let clips=[],allClips=[],creatorFilteredClips=[],groupedSongs=[],currentHeatmapYear=(new Date).getFullYear(),aggregationMode="all",likedOnlyMode=!1,currentCreator="all",currentPlayingClip=null,audioPlayer=null;const insightsCache={tagCounts:null,modelCounts:null,heatmapData:{},lastClipsHash:null};function getClipsHash(){return`${clips.length}-${aggregationMode}-${likedOnlyMode}-${currentCreator}`}function invalidateCacheIfNeeded(){const e=getClipsHash();insightsCache.lastClipsHash!==e&&(insightsCache.tagCounts=null,insightsCache.modelCounts=null,insightsCache.heatmapData={},insightsCache.lastClipsHash=e)}const isUntitled=e=>SunoOfflineDB.isUntitled(e);async function loadData(){showLoadingProgress("Connecting to database...",0);try{const e=await SunoOfflineDB.getGroupedLibrary((e,t,n)=>{switch(e){case"loading":showLoadingProgress("Loading from database...",5);break;case"loaded":showLoadingProgress(`Processing ${t.toLocaleString()} clips...`,10);break;case"grouping":const e=Math.round(10+t/n*70);showLoadingProgress(`Grouping songs... ${t.toLocaleString()}/${n.toLocaleString()}`,e);break;case"sorting":showLoadingProgress("Sorting...",85);break;case"done":showLoadingProgress("Calculating insights...",90)}});groupedSongs=e.songs||[],allClips=[];for(const e of groupedSongs)allClips.push(...e.versions);if(updateClipsForAggregation(),0===clips.length)return hideLoading(),void(0===await SunoOfflineDB.getClipCount()?showEmptyState():showEmptyState("Error loading clips"));showLoadingProgress("Rendering insights...",95),await populateCreatorDropdown();const t=await chrome.storage.local.get(["sunoOfflineConfig"]),n=t.sunoOfflineConfig?.lastIndexedAt;generateAllInsights(),hideLoading();const a=n?`${clips.length.toLocaleString()} clips • Updated: ${formatDate(new Date(n))}`:`${clips.length.toLocaleString()} clips`;document.getElementById("lastUpdated").textContent=a}catch(e){hideLoading(),showEmptyState(e.message)}}function showLoadingProgress(e,t){const n=document.getElementById("loadingOverlay");n&&(n.style.display="flex",n.querySelector(".loading-message").textContent=e,n.querySelector(".loading-bar-fill").style.width=t+"%")}function hideLoading(){const e=document.getElementById("loadingOverlay");e&&(e.style.display="none")}function showIndexingState(e){document.querySelector(".main").innerHTML=`\n    <div class="loading">\n      <div class="spinner"></div>\n      <h2 style="margin: 20px 0 8px;">Indexing in Progress...</h2>\n      <p style="color: var(--text-muted); margin-bottom: 16px;">\n        ${e.indexed||0} clips indexed so far\n      </p>\n      <p style="color: var(--text-muted); font-size: 13px;">\n        Click "Refresh" to see insights with current data\n      </p>\n      <button class="btn-refresh-inline" onclick="location.reload()">\n        🔄 Refresh Now\n      </button>\n    </div>\n  `}function showEmptyState(e){document.querySelector(".main").innerHTML=`\n    <div class="loading">\n      <div style="font-size: 64px; margin-bottom: 20px;">📊</div>\n      <h2 style="margin-bottom: 8px;">No Data Yet</h2>\n      <p style="color: var(--text-muted);">\n        ${e||"Index your library first to see insights!"}\n      </p>\n      <a href="../library/library.html" style="color: var(--accent); margin-top: 16px; display: inline-block;">\n        Go to Library →\n      </a>\n    </div>\n  `}function updateClipsForAggregation(){let e,t=allClips,n=groupedSongs;currentCreator&&"all"!==currentCreator&&(t=allClips.filter(e=>e.user_id===currentCreator),n=groupedSongs.filter(e=>e.versions.some(e=>e.user_id===currentCreator))),e="grouped"===aggregationMode?SunoOfflineDB.getDefinitiveClips(n,{separateTypes:!0}):t,e=(e||[]).filter(e=>e&&e.id),clips=likedOnlyMode?e.filter(e=>e&&e.is_liked):e}function toggleAggregationMode(e){aggregationMode=e?"grouped":"all",refreshInsightsWithLoading()}function toggleLikedOnlyMode(e){likedOnlyMode=e,refreshInsightsWithLoading()}function toggleCreator(e){currentCreator=e,refreshInsightsWithLoading()}function showFilterLoading(e){const t=document.getElementById("filterLoading");t&&(t.style.display=e?"flex":"none")}async function refreshInsightsWithLoading(){showFilterLoading(!0),await new Promise(e=>setTimeout(e,10)),refreshInsights(),showFilterLoading(!1)}function refreshInsights(){updateClipsForAggregation(),vocabularyData=null,tagData={full:[],words:[]},window._genreTagToClips={},generateAllInsights();const e=clips.length,t=document.querySelector(".filter-hint");t&&(t.textContent=likedOnlyMode?`Analyzing ${e.toLocaleString()} liked songs`:"grouped"===aggregationMode?"Uses definitive version per song for stats":"Analyze what makes your favorites pop")}async function populateCreatorDropdown(){const e=await SunoOfflineDB.getUniqueCreators(allClips),t=document.getElementById("creatorSelect");if(e.length<=1)t&&(t.style.display="none");else if(t){t.style.display="",t.innerHTML='<option value="all">👤 All Creators ('+e.reduce((e,t)=>e+t.clipCount,0).toLocaleString()+")</option>";for(const n of e){const e=document.createElement("option");e.value=n.userId,e.textContent=`@${n.handle||n.displayName} (${n.clipCount.toLocaleString()})`,t.appendChild(e)}}}function generateAllInsights(){invalidateCacheIfNeeded(),generateHeroStats(),generateAchievements(),generateTopLiked(),generateTopVersioned(),generateLongestSongs(),generateModelUsage(),generateTagCloud(),generateActivityStats(),generateHeatmap(),generateFunFacts(),generateWordCloud(),generateGenreExplorer(),generateLineageExplorer(),cleanupTempData()}function generateLineageExplorer(){if("undefined"!=typeof LineageExplorer){let e=allClips;currentCreator&&"all"!==currentCreator&&(e=allClips.filter(e=>e.user_id===currentCreator)),LineageExplorer.init(e||clips)}}function cleanupTempData(){window._genreTagToClips&&Object.keys(window._genreTagToClips).length>100&&Object.keys(window._genreTagToClips).slice(100).forEach(e=>delete window._genreTagToClips[e])}document.getElementById("groupVariations")?.addEventListener("change",e=>{toggleAggregationMode(e.target.checked)}),document.getElementById("likedOnlyFilter")?.addEventListener("change",e=>{toggleLikedOnlyMode(e.target.checked)}),document.getElementById("creatorSelect")?.addEventListener("change",e=>{toggleCreator(e.target.value)});const GENRE_TAXONOMY={"Rock & Metal":{icon:"🎸",genres:["rock","metal","punk","grunge","alternative","indie rock","hard rock","heavy metal","death metal","black metal","progressive rock","prog rock","classic rock","soft rock","post-rock","post-punk","new wave","garage rock","psychedelic rock","stoner rock","doom metal","thrash metal","metalcore","deathcore","nu metal","industrial metal","folk metal","symphonic metal","power metal","glam rock","emo","screamo","hardcore","post-hardcore"]},"Electronic & Dance":{icon:"🎧",genres:["electronic","edm","house","techno","trance","dubstep","drum and bass","dnb","d&b","ambient","chillout","downtempo","trip hop","synthwave","retrowave","vaporwave","future bass","trap","hardstyle","breakbeat","jungle","garage","uk garage","deep house","progressive house","tech house","minimal","idm","glitch","industrial","ebm","electro","electronica","experimental electronic","dark ambient","noise"]},"Hip-Hop & R&B":{icon:"🎤",genres:["hip hop","hip-hop","hiphop","rap","r&b","rnb","rhythm and blues","soul","neo soul","trap","drill","boom bap","lo-fi hip hop","lofi","conscious rap","gangsta rap","old school hip hop","underground hip hop","uk grime","grime","afrobeat","afrobeats","dancehall","reggaeton"]},"Pop & Mainstream":{icon:"🌟",genres:["pop","dance pop","synth pop","synthpop","electropop","art pop","dream pop","indie pop","k-pop","kpop","j-pop","jpop","bubblegum pop","teen pop","power pop","chamber pop","baroque pop","disco","funk","nu disco"]},"Jazz & Blues":{icon:"🎺",genres:["jazz","blues","smooth jazz","bebop","swing","big band","fusion","jazz fusion","acid jazz","free jazz","latin jazz","cool jazz","modal jazz","chicago blues","delta blues","electric blues","rhythm and blues"]},"Classical & Orchestral":{icon:"🎻",genres:["classical","orchestral","symphony","symphonic","chamber music","baroque","romantic","contemporary classical","neoclassical","opera","choral","minimalist","impressionist","film score","soundtrack","cinematic","epic","trailer music"]},"Folk & Country":{icon:"🪕",genres:["folk","country","americana","bluegrass","acoustic","singer-songwriter","folk rock","celtic","irish","scottish","world music","traditional","roots","country rock","alt-country","outlaw country","honky tonk","western"]},"World & Latin":{icon:"🌍",genres:["latin","salsa","bossa nova","samba","flamenco","tango","cumbia","merengue","bachata","mariachi","reggae","ska","dub","world","african","middle eastern","indian","asian","brazilian","caribbean","tropical"]},"Styles & Moods":{icon:"🎨",genres:["instrumental","vocal","acoustic","electric","upbeat","melancholic","dark","bright","energetic","calm","atmospheric","ethereal","dreamy","aggressive","heavy","soft","epic","intimate","groovy","funky","melodic","harmonic","dissonant","minimalist","maximalist","lo-fi","hi-fi","vintage","modern","retro","futuristic"]}};function classifyTag(e){const t=e.toLowerCase().trim();for(const[e,n]of Object.entries(GENRE_TAXONOMY))for(const a of n.genres)if(t===a||t.includes(a))return e;return null}function generateGenreExplorer(){const e=document.getElementById("genreOverview");if(!e)return;const t={};clips.forEach(e=>{(e.metadata?.tags?.split(",").map(e=>e.trim()).filter(e=>e)||[]).forEach(e=>{const n=e.toLowerCase().trim();t[n]=(t[n]||0)+1})}),window._genreTagToClips=window._genreTagToClips||{};const n={},a=[];for(const[e,o]of Object.entries(t)){const t=classifyTag(e);t?(n[t]||(n[t]=[]),n[t].push({tag:e,count:o})):o>=3&&a.push({tag:e,count:o})}Object.values(n).forEach(e=>{e.sort((e,t)=>t.count-e.count)}),a.sort((e,t)=>t.count-e.count);let o="";for(const[e,t]of Object.entries(GENRE_TAXONOMY)){const a=n[e]||[];if(0===a.length)continue;const s=a.reduce((e,t)=>e+t.count,0);o+=`\n      <div class="genre-category">\n        <div class="genre-category-header">\n          <span class="genre-category-icon">${t.icon}</span>\n          <span class="genre-category-title">${e}</span>\n          <span class="genre-category-count">${s} uses</span>\n        </div>\n        <div class="genre-tags">\n          ${a.slice(0,15).map(e=>`\n            <button class="genre-tag" data-tag="${escapeHtml(e.tag)}">\n              ${escapeHtml(e.tag)}\n              <span class="genre-tag-count">${e.count}</span>\n            </button>\n          `).join("")}\n          ${a.length>15?`<span class="genre-more">+${a.length-15} more</span>`:""}\n        </div>\n      </div>\n    `}a.length>0&&(o+=`\n      <div class="genre-category">\n        <div class="genre-category-header">\n          <span class="genre-category-icon">✨</span>\n          <span class="genre-category-title">Other Tags</span>\n          <span class="genre-category-count">${a.reduce((e,t)=>e+t.count,0)} uses</span>\n        </div>\n        <div class="genre-tags">\n          ${a.slice(0,20).map(e=>`\n            <button class="genre-tag" data-tag="${escapeHtml(e.tag)}">\n              ${escapeHtml(e.tag)}\n              <span class="genre-tag-count">${e.count}</span>\n            </button>\n          `).join("")}\n          ${a.length>20?`<span class="genre-more">+${a.length-20} more</span>`:""}\n        </div>\n      </div>\n    `),e.innerHTML=o||'<p class="empty-message">No tags found</p>',e.querySelectorAll(".genre-tag").forEach(e=>{e.addEventListener("click",()=>showGenreDetail(e.dataset.tag))})}function renderSongCard(e,t){const n=!e.metadata?.has_vocal;return`\n    <div class="song-card" data-id="${e.id}" data-index="${t}">\n      <button class="card-play" data-index="${t}" title="Play">▶</button>\n      <img class="card-thumb" src="${e.image_url||e.image_large_url||""}" alt="" loading="lazy">\n      <div class="card-info">\n        <div class="card-title">${escapeHtml(e.title||"Untitled")}</div>\n        <div class="card-tags">\n          ${e.is_liked?'<span class="card-tag liked">❤️</span>':""}\n          <span class="card-tag type">${n?"🎸":"🎤"}</span>\n          <span class="card-tag model">${getModelVersion(e)}</span>\n          <span class="card-tag duration">${formatDuration(e.metadata?.duration||0)}</span>\n        </div>\n      </div>\n      <button class="card-menu" data-clip-id="${e.id}" title="More options">⋮</button>\n    </div>\n  `}function renderGenreSongList(e){const t=document.getElementById("genreSongList"),n=[...e].sort((e,t)=>e.is_liked&&!t.is_liked?-1:!e.is_liked&&t.is_liked?1:new Date(t.created_at)-new Date(e.created_at));window._currentGenreClips=n,t.innerHTML=n.slice(0,100).map((e,t)=>renderSongCard(e,t)).join(""),addCardEventHandlers(t),updatePlayingHighlight()}function addCardEventHandlers(e){e.querySelectorAll(".card-play").forEach(e=>{e.addEventListener("click",t=>{t.stopPropagation();const n=parseInt(e.dataset.index),a=window._currentGenreClips[n];a&&playClip(a)})}),e.querySelectorAll(".card-menu").forEach(e=>{e.addEventListener("click",t=>{t.stopPropagation(),showClipMenu(e,e.dataset.clipId)})}),e.querySelectorAll(".song-card").forEach(e=>{e.addEventListener("click",t=>{t.target.closest(".card-play")||t.target.closest(".card-menu")||window.open(`https://suno.com/song/${e.dataset.id}`,"_blank")})})}function showGenreDetail(e){let t=window._genreTagToClips?.[e];t||(t=(clips||[]).filter(e=>e&&e.id&&e.metadata).filter(t=>(t.metadata?.tags?.toLowerCase()||"").split(",").some(t=>t.trim()===e)),window._genreTagToClips=window._genreTagToClips||{},window._genreTagToClips[e]=t),document.getElementById("genreOverview").style.display="none",document.getElementById("genreDetail").style.display="block",document.getElementById("closeGenreDetail").style.display="inline-block",document.getElementById("genreDetailTitle").textContent=`🏷️ "${e}"`,document.getElementById("genreDetailCount").textContent=`${t.length} song${1!==t.length?"s":""}`,renderGenreSongList(t)}function hideGenreDetail(){document.getElementById("genreOverview").style.display="grid",document.getElementById("genreDetail").style.display="none",document.getElementById("closeGenreDetail").style.display="none",window._currentSearchTags=[]}function removeSearchTag(e){window._currentSearchTags&&0!==window._currentSearchTags.length&&(window._currentSearchTags.splice(e,1),0!==window._currentSearchTags.length?1!==window._currentSearchTags.length?showTagCrossSection(window._currentSearchTags):showGenreDetail(window._currentSearchTags[0]):hideGenreDetail())}function performTagSearch(){const e=document.getElementById("tagSearchInput").value.trim();if(!e)return;const t=e.split(",").map(e=>e.trim().toLowerCase()).filter(e=>e.length>0);0!==t.length&&(1===t.length?showWordSearch(t[0]):showTagCrossSection(t),document.getElementById("genreExplorerSection")?.scrollIntoView({behavior:"smooth",block:"start"}))}function showTagCrossSection(e){window._currentSearchTags=[...e];const t=clips.filter(t=>{const n=(t.metadata?.tags||"").toLowerCase();return e.every(e=>n.includes(e))});window._currentGenreClips=t,document.getElementById("genreOverview").style.display="none",document.getElementById("genreDetail").style.display="block",document.getElementById("closeGenreDetail").style.display="inline-block";const n=e.map((e,t)=>`<span class="search-tag-chip">${escapeHtml(e)}<button class="tag-remove-btn" data-index="${t}" title="Remove tag">×</button></span>`).join('<span class="tag-plus">+</span>');document.getElementById("genreDetailTitle").innerHTML="🔍 Cross-section",document.getElementById("genreDetailCount").innerHTML=`\n    <div class="search-tags-display">${n}</div>\n    <span>${t.length} song${1!==t.length?"s":""} matching ALL tags</span>\n  `,document.querySelectorAll(".tag-remove-btn").forEach(e=>{e.addEventListener("click",t=>{t.stopPropagation(),removeSearchTag(parseInt(e.dataset.index))})}),renderGenreSongList(t)}function generateHeroStats(){const e=(clips||[]).filter(e=>e&&e.id),t=(e.reduce((e,t)=>e+(t?.metadata?.duration||0),0)/3600).toFixed(1),n=e.filter(e=>e?.is_liked).length,a=e.filter(e=>e?.is_disliked).length,o=e.length>0?(n/e.length*100).toFixed(1):0,s=e.length>0?(a/e.length*100).toFixed(1):0;document.getElementById("totalSongs").textContent=e.length.toLocaleString(),document.getElementById("totalHours").textContent=t,document.getElementById("likeRate").textContent=`${o}%`,document.getElementById("uniqueSongs").textContent=(groupedSongs||[]).length.toLocaleString();const i=document.getElementById("dislikeRate");i&&(i.textContent=`${s}%`)}function generateAchievements(){const e=[];clips.length>=100&&e.push({icon:"🎵",title:"Century Club",value:"100+ songs",tier:"bronze"}),clips.length>=500&&e.push({icon:"🎸",title:"Prolific Producer",value:"500+ songs",tier:"silver"}),clips.length>=1e3&&e.push({icon:"🎹",title:"Music Machine",value:"1000+ songs",tier:"gold"}),clips.length>=5e3&&e.push({icon:"👑",title:"Legendary Creator",value:"5000+ songs",tier:"gold"});const t=clips.reduce((e,t)=>e+(t.metadata?.duration||0),0)/3600;t>=10&&e.push({icon:"⏱️",title:"Time Traveler",value:"10+ hours of music",tier:"bronze"}),t>=50&&e.push({icon:"🕐",title:"Marathon Master",value:"50+ hours of music",tier:"silver"}),t>=100&&e.push({icon:"⌛",title:"Eternal Composer",value:"100+ hours of music",tier:"gold"});const n=Math.max(...clips.map(e=>e.metadata?.duration||0));n>=180&&e.push({icon:"📏",title:"Epic Creator",value:"3+ min song",tier:"bronze"}),n>=300&&e.push({icon:"🎭",title:"Odyssey Maker",value:"5+ min song",tier:"silver"}),n>=480&&e.push({icon:"🏔️",title:"Mountain Climber",value:"8+ min song",tier:"gold"});const a=groupedSongs.filter(e=>!isUntitled(e.displayTitle)),o=a.length>0?Math.max(...a.map(e=>e.versions.length)):0;o>=5&&e.push({icon:"🔄",title:"Perfectionist",value:"5+ versions of a song",tier:"bronze"}),o>=10&&e.push({icon:"🔁",title:"Obsessive Refiner",value:"10+ versions",tier:"silver"}),o>=20&&e.push({icon:"♾️",title:"Never Satisfied",value:"20+ versions",tier:"gold"});const s=clips.filter(e=>e.is_liked).length;s>=50&&e.push({icon:"❤️",title:"Self Love",value:"50+ liked songs",tier:"bronze"}),s>=200&&e.push({icon:"💕",title:"Curator",value:"200+ liked songs",tier:"silver"}),s>=500&&e.push({icon:"💖",title:"Treasure Hunter",value:"500+ liked songs",tier:"gold"});const i=clips.filter(e=>e.is_disliked).length;i>=20&&e.push({icon:"🧹",title:"Quality Control",value:"20+ disliked songs",tier:"bronze"}),i>=100&&e.push({icon:"🗑️",title:"Harsh Critic",value:"100+ disliked songs",tier:"silver"}),i>=500&&e.push({icon:"💀",title:"The Purger",value:"500+ disliked songs",tier:"gold"});const l={};clips.forEach(e=>{const t=e.major_model_version||"unknown";l[t]=(l[t]||0)+1}),l.v5>=100&&e.push({icon:"🚀",title:"Cutting Edge",value:"100+ v5 songs",tier:"silver"}),Object.keys(l).length>=3&&e.push({icon:"🌈",title:"Model Explorer",value:"Used 3+ models",tier:"bronze"});const r=clips.map(e=>new Date(e.created_at).toDateString()),d=new Set(r);d.size>=7&&e.push({icon:"📅",title:"Week Warrior",value:"Created on 7+ days",tier:"bronze"}),d.size>=30&&e.push({icon:"🗓️",title:"Monthly Master",value:"Created on 30+ days",tier:"silver"}),d.size>=100&&e.push({icon:"📆",title:"Dedicated Creator",value:"100+ creation days",tier:"gold"});const c=clips.filter(e=>isUntitled(e.title)).length,u=clips.length>0?Math.round(c/clips.length*100):0,g=groupedSongs.find(e=>isUntitled(e.displayTitle)||isUntitled(e.baseTitle)),m=g?.versions?.length||c;c>=10&&e.push({icon:"🤷",title:"Naming is Hard",value:`${c} untitled songs`,tier:"bronze"}),c>=50&&e.push({icon:"🎭",title:"Mystery Producer",value:`${c} songs unnamed`,tier:"silver"}),c>=200&&e.push({icon:"👻",title:"The Anonymous Artist",value:`${c} untitled!`,tier:"gold"}),m>=100&&e.push({icon:"♾️",title:"Untitled: The Saga",value:`${m} variations of nothing`,tier:"gold"}),u>=50&&e.push({icon:"🙈",title:"Names Are Overrated",value:`${u}% untitled`,tier:"silver"});const p=document.getElementById("achievementsGrid");0!==e.length?p.innerHTML=e.map(e=>`\n    <div class="achievement ${e.tier}">\n      <span class="achievement-icon">${e.icon}</span>\n      <div class="achievement-title">${e.title}</div>\n      <div class="achievement-value">${e.value}</div>\n    </div>\n  `).join(""):p.innerHTML='<p style="color: var(--text-muted);">Keep creating to unlock achievements!</p>'}function generateTopLiked(){const e=clips.filter(e=>{if(!e.is_liked)return!1;const t=e.title||"";return!!t.trim()&&"untitled"!==t.toLowerCase().trim()&&!/^untitled\s*\d*$/i.test(t.trim())}).sort((e,t)=>new Date(t.created_at)-new Date(e.created_at)).slice(0,10),t=document.getElementById("topLiked");0!==e.length?(window._topLikedClips=e,t.innerHTML=e.map((e,t)=>{e.metadata;const n=getClipTagsHtml(e);return`\n    <div class="top-item playable-item" data-index="${t}" data-list="liked" data-clip-id="${e.id}">\n      <button class="top-play-btn" data-index="${t}" data-list="liked" title="Play">▶</button>\n      <span class="top-rank ${t<3?"rank-"+(t+1):"rank-other"}">${t+1}</span>\n      ${e.image_url?`<img class="top-cover" src="${e.image_url}" alt="">`:""}\n      <div class="top-info">\n        <div class="top-title">${escapeHtml(e.title||"Untitled")}</div>\n        <div class="top-meta">${n}</div>\n      </div>\n      <button class="top-item-menu" data-clip-id="${e.id}" title="More options">⋮</button>\n    </div>\n  `}).join(""),addTopItemPlayHandlers(t,"liked"),addTopItemMenuHandlers(t)):t.innerHTML='<p style="color: var(--text-muted); padding: 20px;">No liked songs yet (excluding Untitled)</p>'}function generateTopVersioned(){const e=[...groupedSongs].filter(e=>{if(e.versions.length<=1)return!1;const t=e.displayTitle||e.baseTitle||"";return!!t.trim()&&"untitled"!==t.toLowerCase().trim()&&!/^untitled\s*\d*$/i.test(t.trim())}).sort((e,t)=>t.versions.length-e.versions.length).slice(0,10),t=document.getElementById("topVersioned");0!==e.length?t.innerHTML=e.map((e,t)=>{const n=e.versions[0];return`\n      <div class="top-item">\n        <span class="top-rank ${t<3?"rank-"+(t+1):"rank-other"}">${t+1}</span>\n        ${n?.image_url?`<img class="top-cover" src="${n.image_url}" alt="">`:""}\n        <div class="top-info">\n          <div class="top-title">${escapeHtml(e.displayTitle||e.baseTitle||"Untitled")}</div>\n          <div class="top-meta">${e.likedVersions||0} liked</div>\n        </div>\n        <span class="top-value">${e.versions.length} versions</span>\n      </div>\n    `}).join(""):t.innerHTML='<p style="color: var(--text-muted); padding: 20px;">No multi-version songs yet (excluding Untitled)</p>'}function generateLongestSongs(){const e=[...clips].filter(e=>e.metadata?.duration&&!isUntitled(e.title)).sort((e,t)=>(t.metadata?.duration||0)-(e.metadata?.duration||0)).slice(0,10),t=document.getElementById("longestSongs");0!==e.length?(window._topLongestClips=e,t.innerHTML=e.map((e,t)=>{const n=getClipTagsHtml(e);return`\n    <div class="top-item playable-item" data-index="${t}" data-list="longest" data-clip-id="${e.id}">\n      <button class="top-play-btn" data-index="${t}" data-list="longest" title="Play">▶</button>\n      <span class="top-rank ${t<3?"rank-"+(t+1):"rank-other"}">${t+1}</span>\n      ${e.image_url?`<img class="top-cover" src="${e.image_url}" alt="">`:""}\n      <div class="top-info">\n        <div class="top-title">${escapeHtml(e.title||"Untitled")}</div>\n        <div class="top-meta">${n}</div>\n      </div>\n      <span class="top-value">${formatDuration(e.metadata?.duration)}</span>\n      <button class="top-item-menu" data-clip-id="${e.id}" title="More options">⋮</button>\n    </div>\n  `}).join(""),addTopItemPlayHandlers(t,"longest"),addTopItemMenuHandlers(t)):t.innerHTML='<p style="color: var(--text-muted); padding: 20px;">No songs with duration data yet</p>'}function getClipTagsHtml(e){const t=[];e.is_liked&&t.push('<span class="clip-tag liked">❤️</span>');const n=!e.metadata?.has_vocal;return t.push(`<span class="clip-tag type">${n?"🎸":"🎤"}</span>`),t.push(`<span class="clip-tag model">${getModelVersion(e)}</span>`),t.push(`<span class="clip-tag duration">${formatDuration(e.metadata?.duration)}</span>`),t.join("")}function addTopItemPlayHandlers(e,t){e.querySelectorAll(".top-play-btn").forEach(e=>{e.addEventListener("click",n=>{n.stopPropagation();const a=parseInt(e.dataset.index),o={liked:window._topLikedClips,longest:window._topLongestClips},s=o[t]?.[a];s&&playClip(s)})})}function addTopItemMenuHandlers(e){e.querySelectorAll(".top-item-menu").forEach(e=>{e.addEventListener("click",t=>{t.stopPropagation(),showClipMenu(e,e.dataset.clipId)})})}function showClipMenu(e,t){const n=allClips.find(e=>e.id===t);if(!n)return;document.querySelectorAll(".clip-context-menu").forEach(e=>e.remove());const a=SunoOfflineDB.normalizeTitle(n.title||"Untitled"),o=document.createElement("div");o.className="clip-context-menu",o.innerHTML='\n    <button class="menu-item" data-action="set-custom-name">📝 Set Custom Name</button>\n    <button class="menu-item" data-action="set-definitive">⭐ Set as Definitive</button>\n    <hr>\n    <button class="menu-item" data-action="open-suno">🔗 Open on Suno</button>\n  ';const s=e.getBoundingClientRect();o.style.position="fixed",o.style.top=`${s.bottom+4}px`,o.style.left=`${Math.min(s.left-100,window.innerWidth-200)}px`,o.style.zIndex="2000",document.body.appendChild(o),o.querySelectorAll(".menu-item").forEach(e=>{e.addEventListener("click",async()=>{const s=e.dataset.action;"set-custom-name"===s?(o.remove(),showCustomNameModal(a,n.title)):"set-definitive"===s?(await SunoOfflineDB.setDefinitiveVersion(a,t),showToast("Set as definitive version","success"),o.remove()):"open-suno"===s&&(window.open(`https://suno.com/song/${t}`,"_blank"),o.remove())})}),setTimeout(()=>{document.addEventListener("click",function e(t){o.contains(t.target)||(o.remove(),document.removeEventListener("click",e))})},0)}function getModelVersion(e){if(e.major_model_version)return e.major_model_version;const t=e.model_name||e.metadata?.model_name||"";if(t.includes("chirp-v4"))return"v4";if(t.includes("chirp-v3"))return"v3.5";if(t.includes("chirp-v2"))return"v2";if(t.includes("bark"))return"v1";if(t.includes("carp"))return"v5";const n=e.metadata?.model_badges||[];if(Array.isArray(n))for(const e of n){if(e.includes("4.5"))return"v4.5";if(e.includes("v4"))return"v4";if(e.includes("v3"))return"v3.5"}return"upload"===e.metadata?.type||!e.major_model_version&&!t?"📤 Upload":t||"unknown"}function generateModelUsage(){const e={};clips.forEach(t=>{const n=getModelVersion(t);e[n]=(e[n]||0)+1});const t=clips.length,n=Object.entries(e).sort((e,t)=>t[1]-e[1]);document.getElementById("modelBars").innerHTML=n.map(([e,n])=>{const a=(n/t*100).toFixed(1),o=getModelCssClass(e);return`\n      <div class="model-bar">\n        <div class="model-bar-header">\n          <span class="model-bar-label">${e}</span>\n          <span class="model-bar-value">${n.toLocaleString()} (${a}%)</span>\n        </div>\n        <div class="model-bar-track">\n          <div class="model-bar-fill ${o}" style="width: ${a}%"></div>\n        </div>\n      </div>\n    `}).join("")}function getModelCssClass(e){const t=e.toLowerCase();return t.includes("upload")?"upload":t.includes("5")?"v5":t.includes("4.5")||t.includes("45")?"v45":t.includes("4")?"v4":t.includes("3.5")||t.includes("35")?"v35":t.includes("3")?"v3":t.includes("chirp")?"chirp":"other"}document.getElementById("closeGenreDetail")?.addEventListener("click",hideGenreDetail),document.getElementById("tagSearchBtn")?.addEventListener("click",performTagSearch),document.getElementById("tagSearchInput")?.addEventListener("keydown",e=>{"Enter"===e.key&&performTagSearch()});let tagData={full:[],words:[]},currentTagView="full";function generateTagCloud(){if(insightsCache.tagCounts)return tagData=insightsCache.tagCounts,void renderTagCloud();const e={},t={};clips.forEach(n=>{const a=n.metadata?.tags||"";a.split(",").forEach(t=>{if((t=t.trim())&&t.length>1&&t.length<50){const n=t.toLowerCase();e[n]=e[n]||{display:t,count:0},e[n].count++}}),a.split(/[\s,]+/).forEach(e=>{(e=e.trim().toLowerCase())&&e.length>2&&e.length<20&&(t[e]=(t[e]||0)+1)})}),tagData.full=Object.entries(e).map(([e,t])=>({tag:t.display,count:t.count})).sort((e,t)=>t.count-e.count).slice(0,30),tagData.words=Object.entries(t).map(([e,t])=>({tag:e,count:t})).sort((e,t)=>t.count-e.count).slice(0,30),insightsCache.tagCounts={...tagData},renderTagCloud()}function renderTagCloud(){const e="full"===currentTagView?tagData.full:tagData.words,t=document.getElementById("tagCloud");if(0===e.length)return void(t.innerHTML='<p style="color: var(--text-muted);">No tags found</p>');const n=e[0].count,a=document.getElementById("showTagCounts")?.checked??!0;t.className="tag-cloud"+(a?"":" hide-counts"),t.innerHTML=e.map(({tag:e,count:t})=>{const a=t/n;let o=1;return a>.8?o=5:a>.5?o=4:a>.3?o=3:a>.1&&(o=2),`<span class="tag size-${o} clickable-tag" data-tag="${escapeHtml(e.toLowerCase())}" title="Click to explore • ${t} uses">${escapeHtml(e)}<span class="tag-badge">${t}</span></span>`}).join(""),t.querySelectorAll(".clickable-tag").forEach(e=>{e.addEventListener("click",()=>{const t=e.dataset.tag;window._genreTagToClips||(window._genreTagToClips={},clips.forEach(e=>{(e.metadata?.tags?.split(",").map(e=>e.trim().toLowerCase()).filter(e=>e)||[]).forEach(t=>{window._genreTagToClips[t]||(window._genreTagToClips[t]=[]),window._genreTagToClips[t].push(e)})})),showGenreDetail(t),document.getElementById("genreExplorerSection")?.scrollIntoView({behavior:"smooth"})})})}function generateActivityStats(){const e=clips.map(e=>new Date(e.created_at)),t={},n={};e.forEach(e=>{const a=e.toLocaleDateString("en-US",{weekday:"long"}),o=e.getHours();t[a]=(t[a]||0)+1,n[o]=(n[o]||0)+1});const a=Object.entries(t).sort((e,t)=>t[1]-e[1])[0],o=Object.entries(n).sort((e,t)=>t[1]-e[1])[0],s=o?formatHour(parseInt(o[0])):"-",i=[...new Set(e.map(e=>e.toDateString()))].sort((e,t)=>new Date(t)-new Date(e));let l=0,r=0,d=null;i.forEach(e=>{const t=new Date(e);d&&(d-t)/864e5<=1?(l++,r=Math.max(r,l)):l=1,d=t});const c=new Set(e.map(e=>e.toDateString())).size,u=c>0?(clips.length/c).toFixed(1):0;document.getElementById("activityStats").innerHTML=`\n    <div class="activity-stat">\n      <div class="activity-stat-value">${a?a[0]:"-"}</div>\n      <div class="activity-stat-label">Most Productive Day</div>\n    </div>\n    <div class="activity-stat">\n      <div class="activity-stat-value">${s}</div>\n      <div class="activity-stat-label">Peak Creation Hour</div>\n    </div>\n    <div class="activity-stat">\n      <div class="activity-stat-value">${r}</div>\n      <div class="activity-stat-label">Longest Streak (days)</div>\n    </div>\n    <div class="activity-stat">\n      <div class="activity-stat-value">${u}</div>\n      <div class="activity-stat-label">Avg Songs/Active Day</div>\n    </div>\n  `}function generateHeatmap(e=null){null!==e&&(currentHeatmapYear=e);const t=new Date,n=currentHeatmapYear,a=n===t.getFullYear();document.getElementById("heatmapYear").textContent=n,document.getElementById("nextYear").disabled=a;const o=clips.reduce((e,t)=>{const n=new Date(t.created_at);return n<e?n:e},new Date);document.getElementById("prevYear").disabled=n<=o.getFullYear();const s={};let i=0;clips.forEach(e=>{const t=new Date(e.created_at);if(t.getFullYear()===n){const e=t.toDateString();s[e]=(s[e]||0)+1,i++}});const l=Math.max(1,...Object.values(s)),r=new Date(n,0,1),d=r.getDay();r.setDate(r.getDate()-d);const c=a?t:new Date(n,11,31),u=document.getElementById("heatmapMonths"),g=[];let m=-1,p=0,h="";const v=new Date(r);for(;v<=c;){const e=v.getMonth();v.getFullYear()===n&&(e!==m?(-1!==m&&g.push({name:h,weeks:p}),m=e,h=v.toLocaleDateString("en-US",{month:"short"}),p=1):p++),v.setDate(v.getDate()+7)}p>0&&g.push({name:h,weeks:p}),u.innerHTML=g.map(e=>`<span class="heatmap-month" style="width: ${16*e.weeks}px">${e.name}</span>`).join("");const y=document.getElementById("heatmap");let f="",w=0,C=0;const E=new Date(r);for(;E<=c||0!==E.getDay();){0===E.getDay()&&(f+='<div class="heatmap-week">');const e=E.toDateString(),a=s[e]||0,o=E.getFullYear()===n,i=E>t;a>0&&o?(C++,w=Math.max(w,C)):C=0;let r=0;a>0&&(r=a>=.8*l?5:a>=.6*l?4:a>=.4*l?3:a>=.2*l?2:1),f+=!o||i?'<div class="heatmap-cell" data-level="0" style="opacity: 0.15"></div>':`<div class="heatmap-cell" data-level="${r}" title="${E.toLocaleDateString("en-US",{weekday:"short",month:"short",day:"numeric"})}: ${a} song${1!==a?"s":""}"></div>`,6===E.getDay()&&(f+="</div>"),E.setDate(E.getDate()+1)}y.innerHTML=f,document.getElementById("heatmapTotal").textContent=`${i.toLocaleString()} songs in ${n}`,document.getElementById("heatmapStreak").textContent=`${w} day best streak`}function generateFunFacts(){const e=[],t=clips.reduce((e,t)=>e+(t.metadata?.duration||0),0),n=Math.floor(t/60);if(n>60){const t=Math.floor(n/120);e.push({icon:"🎬",title:"Movie Marathon",value:`You've created enough music to score <strong>${t} full-length movies</strong>!`})}const a={};clips.forEach(e=>{const t=new Date(e.created_at).getHours();a[t]=(a[t]||0)+1});const o=Object.entries(a).sort((e,t)=>t[1]-e[1])[0];if(o){const t=parseInt(o[0])>=22||parseInt(o[0])<=4;e.push({icon:t?"🦉":"☀️",title:t?"Night Owl":"Early Bird",value:`Your peak creation time is <strong>${formatHour(parseInt(o[0]))}</strong> with ${o[1]} songs!`})}let s=groupedSongs;currentCreator&&"all"!==currentCreator&&(s=groupedSongs.filter(e=>e.versions.some(e=>e.user_id===currentCreator)));const i=[...s].filter(e=>!isUntitled(e.displayTitle)).sort((e,t)=>t.versions.length-e.versions.length)[0];i&&i.versions.length>3&&e.push({icon:"🔄",title:"Perfectionist Alert",value:`You've created <strong>${i.versions.length} versions</strong> of "${escapeHtml(i.displayTitle)}"!`});const l=s.find(e=>isUntitled(e.displayTitle));l&&l.versions.length>=50&&e.push({icon:"🤷",title:"The Nameless Hoard",value:`You have <strong>${l.versions.length} unnamed songs</strong>. Naming things is hard!`});const r=new Set;clips.forEach(e=>{(e.metadata?.tags||"").split(",").forEach(e=>{e.trim()&&r.add(e.trim().toLowerCase())})}),r.size>50&&e.push({icon:"🎨",title:"Genre Explorer",value:`You've experimented with <strong>${r.size} different tags/genres</strong>!`});const d=[...clips].sort((e,t)=>new Date(e.created_at)-new Date(t.created_at))[0];if(d){const t=Math.floor((Date.now()-new Date(d.created_at))/864e5);e.push({icon:"🎂",title:"Your Journey",value:`Your first indexed song was <strong>${t} days ago</strong>: "${escapeHtml(d.title||"Untitled")}"!`})}const c=clips.filter(e=>e.is_liked).length;if(c>0&&clips.length>10){const t=(c/clips.length*100).toFixed(0);let n="";n=t>50?"You're your own biggest fan! 😎":t>20?"You've got selective taste! 🧐":"You're a tough critic! 💪",e.push({icon:"❤️",title:"Self-Critic Level",value:`You've liked <strong>${t}%</strong> of your songs. ${n}`})}const u={};clips.forEach(e=>{if(!e.created_at)return;const t=new Date(e.created_at),n=`${t.getFullYear()}-${String(t.getMonth()+1).padStart(2,"0")}`,a=getModelVersion(e);"v?"!==a&&"📤 Upload"!==a&&(u[n]||(u[n]={}),u[n][a]=(u[n][a]||0)+1)});const g=Object.keys(u).sort();if(g.length>=2){const t=g[0],n=g[g.length-1],a=Object.entries(u[t]).sort((e,t)=>t[1]-e[1])[0]?.[0],o=Object.entries(u[n]).sort((e,t)=>t[1]-e[1])[0]?.[0];a&&o&&a!==o&&e.push({icon:"📈",title:"Model Evolution",value:`You started with <strong>${a}</strong> and now mainly use <strong>${o}</strong>!`})}let m=0,p=0;if(clips.forEach(e=>{const t=new Date(e.created_at).getDay();0===t||6===t?m++:p++}),clips.length>20){const t=m/(m+p);t>.4?e.push({icon:"🎉",title:"Weekend Warrior",value:`<strong>${Math.round(100*t)}%</strong> of your songs were created on weekends!`}):t<.2&&e.push({icon:"💼",title:"Work Week Creator",value:`You create most during weekdays - <strong>${Math.round(100*(1-t))}%</strong> of your songs!`})}const h=clips.filter(e=>isUntitled(e.title));if(h.length>=10){const t=Math.round(h.length/clips.length*100);let n="";n=t>=50?"Titles are just suggestions anyway, right? 😅":t>=25?"Your songs speak for themselves!":"A few mysteries in every collection!",e.push({icon:"🎭",title:"The Untitled Collection",value:`You have <strong>${h.length} untitled songs</strong> (${t}%). ${n}`})}const v=document.getElementById("funFacts");0!==e.length?v.innerHTML=e.map(e=>`\n    <div class="fun-fact">\n      <span class="fun-fact-icon">${e.icon}</span>\n      <div class="fun-fact-content">\n        <div class="fun-fact-title">${e.title}</div>\n        <div class="fun-fact-value">${e.value}</div>\n      </div>\n    </div>\n  `).join(""):v.innerHTML='<p style="color: var(--text-muted);">Create more songs to unlock fun facts!</p>'}function escapeHtml(e){if(!e)return"";const t=document.createElement("div");return t.textContent=e,t.innerHTML}function formatDuration(e){return e?`${Math.floor(e/60)}:${Math.floor(e%60).toString().padStart(2,"0")}`:"--:--"}function formatDate(e){return!e||isNaN(e)?"-":e.toLocaleDateString("en-US",{month:"short",day:"numeric",year:"numeric"})}function formatHour(e){return`${e%12||12} ${e>=12?"PM":"AM"}`}document.querySelectorAll(".tag-tab").forEach(e=>{e.addEventListener("click",()=>{document.querySelectorAll(".tag-tab").forEach(e=>e.classList.remove("active")),e.classList.add("active"),currentTagView=e.dataset.view,renderTagCloud()})}),document.getElementById("showTagCounts")?.addEventListener("change",renderTagCloud),document.getElementById("prevYear")?.addEventListener("click",()=>{generateHeatmap(currentHeatmapYear-1)}),document.getElementById("nextYear")?.addEventListener("click",()=>{generateHeatmap(currentHeatmapYear+1)});let vocabularyData=null,currentDnaSource="lyrics",currentDnaView="words";async function generateWordCloud(){vocabularyData||(vocabularyData=await SunoOfflineDB.analyzeVocabulary(),vocabularyData.lyricsPhrases=extractPhrases(clips,"lyrics"),vocabularyData.tagsPhrases=extractPhrases(clips,"tags"),vocabularyData.combinedPhrases=mergePhrases(vocabularyData.lyricsPhrases,vocabularyData.tagsPhrases)),renderWordCloud()}function extractPhrases(e,t){const n={};return e.forEach(e=>{let a="";"lyrics"===t?a=e.metadata?.prompt||"":"tags"===t&&(a=e.metadata?.tags||""),("tags"===t?a.split(","):a.split(/[,\n]+/)).forEach(e=>{const t=(e=e.trim().toLowerCase()).split(/\s+/).length;e&&e.length>3&&e.length<40&&t>=2&&t<=5&&(n[e]=n[e]||{display:e,count:0},n[e].count++)})}),Object.values(n).filter(e=>e.count>=2).sort((e,t)=>t.count-e.count).slice(0,60)}function mergePhrases(e,t){const n={};return[...e,...t].forEach(e=>{const t=e.display;n[t]||(n[t]={display:t,count:0}),n[t].count+=e.count}),Object.values(n).sort((e,t)=>t.count-e.count).slice(0,60)}function renderWordCloud(){const e=document.getElementById("wordCloud"),t=document.getElementById("showDnaCounts")?.checked??!0;let n;if("words"===currentDnaView)n=vocabularyData?.[currentDnaSource]||[];else{const e=currentDnaSource+"Phrases";n=vocabularyData?.[e]||[]}if(0===n.length)return void(e.innerHTML='<p style="color: var(--text-muted);">Not enough data yet</p>');e.className="word-cloud"+(t?"":" hide-counts");const a=[...n].sort(()=>Math.random()-.5),o=Math.max(...n.map(e=>e.count||e.count)),s="tags"===currentDnaSource||"combined"===currentDnaSource;e.innerHTML=a.map(e=>{const t=e.word||e.display,n=e.count,a=n/o;let i=1;return a>.8?i=5:a>.5?i=4:a>.3?i=3:a>.15&&(i=2),`<span class="word-cloud-word size-${i} ${s?"clickable-dna-tag":""}" ${s?`data-tag="${escapeHtml(t.toLowerCase())}"`:""} title="${s?`Click to explore • ${n} occurrences`:`${n} occurrences`}">${escapeHtml(t)}<span class="tag-badge">${n}</span></span>`}).join(""),s&&e.querySelectorAll(".clickable-dna-tag").forEach(e=>{e.addEventListener("click",()=>{showWordSearch(e.dataset.tag),document.getElementById("genreExplorerSection")?.scrollIntoView({behavior:"smooth"})})})}function showWordSearch(e){const t=[],n=e.toLowerCase();clips.forEach(e=>{(e.metadata?.tags||"").toLowerCase().includes(n)&&t.push(e)});const a=[...new Map(t.map(e=>[e.id,e])).values()];window._currentGenreClips=a,window._genreTagToClips=window._genreTagToClips||{},window._genreTagToClips[n]=a,document.getElementById("genreOverview").style.display="none",document.getElementById("genreDetail").style.display="block",document.getElementById("closeGenreDetail").style.display="inline-block",document.getElementById("genreDetailTitle").textContent=`🔍 "${e}"`,document.getElementById("genreDetailCount").textContent=`${a.length} song${1!==a.length?"s":""} with this in tags`,renderGenreSongList(a)}document.querySelectorAll(".wc-tab").forEach(e=>{e.addEventListener("click",()=>{document.querySelectorAll(".wc-tab").forEach(e=>e.classList.remove("active")),e.classList.add("active"),currentDnaSource=e.dataset.source,renderWordCloud()})}),document.querySelectorAll(".dna-view-tab").forEach(e=>{e.addEventListener("click",()=>{document.querySelectorAll(".dna-view-tab").forEach(e=>e.classList.remove("active")),e.classList.add("active"),currentDnaView=e.dataset.view,renderWordCloud()})}),document.getElementById("showDnaCounts")?.addEventListener("change",renderWordCloud);let pendingCustomNameBaseTitle=null,customNames={};async function loadCustomNames(){customNames=await SunoOfflineDB.getAllCustomNames()}function showCustomNameModal(e,t){pendingCustomNameBaseTitle=e;const n=document.getElementById("customNameModal"),a=document.getElementById("customNameInput");document.getElementById("modalOriginalName").textContent=`Original: ${t||e}`,a.value=customNames[e]||"",n.style.display="flex",a.focus(),a.select()}function hideCustomNameModal(){document.getElementById("customNameModal").style.display="none",pendingCustomNameBaseTitle=null}async function saveCustomName(){if(!pendingCustomNameBaseTitle)return;const e=document.getElementById("customNameInput").value.trim();await SunoOfflineDB.setCustomName(pendingCustomNameBaseTitle,e||null),customNames=await SunoOfflineDB.getAllCustomNames(),hideCustomNameModal(),showToast(e?"Custom name saved!":"Custom name cleared","success")}async function clearCustomNameFromModal(){pendingCustomNameBaseTitle&&(await SunoOfflineDB.setCustomName(pendingCustomNameBaseTitle,null),customNames=await SunoOfflineDB.getAllCustomNames(),hideCustomNameModal(),showToast("Custom name cleared","success"))}function showToast(e,t="info"){const n=document.getElementById("toast");n&&(n.textContent=e,n.className=`toast show ${t}`,setTimeout(()=>{n.classList.remove("show")},3e3))}function initPlayer(){audioPlayer=document.getElementById("audioPlayer"),audioPlayer&&(audioPlayer.addEventListener("timeupdate",()=>{if(!currentPlayingClip)return;const e=audioPlayer.currentTime,t=audioPlayer.duration||0,n=t>0?e/t*100:0;document.getElementById("npProgressFill").style.width=`${n}%`,document.getElementById("npCurrentTime").textContent=formatTime(e),document.getElementById("npDuration").textContent=formatTime(t)}),audioPlayer.addEventListener("play",()=>{document.getElementById("npPlayPause").textContent="⏸",updatePlayingHighlight()}),audioPlayer.addEventListener("pause",()=>{document.getElementById("npPlayPause").textContent="▶"}),audioPlayer.addEventListener("ended",()=>{document.getElementById("npPlayPause").textContent="▶"}),document.getElementById("npPlayPause")?.addEventListener("click",togglePlayPause),document.getElementById("npProgressBar")?.addEventListener("click",e=>{const t=e.currentTarget.getBoundingClientRect(),n=(e.clientX-t.left)/t.width;audioPlayer.duration&&(audioPlayer.currentTime=n*audioPlayer.duration)}),document.getElementById("npSunoLink")?.addEventListener("click",()=>{currentPlayingClip&&window.open(`https://suno.com/song/${currentPlayingClip.id}`,"_blank")}),document.getElementById("npMenu")?.addEventListener("click",e=>{currentPlayingClip&&showClipMenu(e.target,currentPlayingClip.id)}))}function playClip(e){if(!audioPlayer||!e)return;currentPlayingClip=e;const t=e.audio_url||`https://cdn1.suno.ai/${e.id}.mp3`;audioPlayer.src=t,audioPlayer.play().catch(e=>{}),showNowPlayingBar(e),updatePlayingHighlight()}function showNowPlayingBar(e){const t=document.getElementById("nowPlayingBar");if(!t)return;t.style.display="flex",document.getElementById("npCover").src=e.image_url||e.image_large_url||"",document.getElementById("npTitle").textContent=e.title||"Untitled";const n=[];e.is_liked&&n.push('<span class="np-tag liked">❤️</span>');const a=!e.metadata?.has_vocal;n.push(`<span class="np-tag">${a?"🎸 Instrumental":"🎤 Vocal"}</span>`),e.metadata?.model_name&&n.push(`<span class="np-tag model">${e.metadata.model_name}</span>`),document.getElementById("npTags").innerHTML=n.join("")}function togglePlayPause(){audioPlayer&&(audioPlayer.paused?audioPlayer.play():audioPlayer.pause())}function updatePlayingHighlight(){if(document.querySelectorAll(".song-card.playing, .playable-item.playing").forEach(e=>{e.classList.remove("playing")}),currentPlayingClip){const e=document.querySelector(`.song-card[data-id="${currentPlayingClip.id}"]`);e&&e.classList.add("playing"),["liked","longest"].forEach(e=>{const t=({liked:window._topLikedClips,longest:window._topLongestClips}[e]||[]).findIndex(e=>e.id===currentPlayingClip.id);if(t>=0){const n=document.querySelector(`.playable-item[data-list="${e}"][data-index="${t}"]`);n&&n.classList.add("playing")}})}}function formatTime(e){return!e||isNaN(e)?"0:00":`${Math.floor(e/60)}:${Math.floor(e%60).toString().padStart(2,"0")}`}function hideValidationModal(){document.getElementById("validationModal").style.display="none"}async function showValidationReport(){const e=document.getElementById("validationModal"),t=document.getElementById("validationBody"),n=document.getElementById("validationActions");e.style.display="flex",t.innerHTML='<div class="validation-loading">Analyzing data...</div>',n.style.display="none",await new Promise(e=>setTimeout(e,100));const a=validateLibraryData();t.innerHTML=renderValidationReport(a),n.style.display="flex"}function validateLibraryData(){const e={totalClips:allClips.length,issues:{missingModel:[],unknownModel:[],missingDuration:[],missingTags:[],missingImage:[],missingTitle:[],potentiallyStale:[]},modelDistribution:{},dataCompleteness:0};new Date,allClips.forEach(t=>{const n=getModelVersion(t);e.modelDistribution[n]=(e.modelDistribution[n]||0)+1,"unknown"!==n&&"v?"!==n||e.issues.unknownModel.push({id:t.id,title:t.title}),t.major_model_version||t.model_name||"upload"===t.metadata?.type||e.issues.missingModel.push({id:t.id,title:t.title}),t.metadata?.duration||e.issues.missingDuration.push({id:t.id,title:t.title});const a="upload"===t.metadata?.type||"uploaded"===t.metadata?.type;t.metadata?.tags&&""!==t.metadata.tags.trim()||a||e.issues.missingTags.push({id:t.id,title:t.title}),t.image_url||t.image_large_url||e.issues.missingImage.push({id:t.id,title:t.title}),t.title&&""!==t.title.trim()&&"Untitled"!==t.title||e.issues.missingTitle.push({id:t.id,title:t.title||"(no title)"}),new Date(t.created_at).getFullYear()>=2024&&(t.major_model_version||t.metadata?.model_badges||e.issues.potentiallyStale.push({id:t.id,title:t.title,reason:"Missing model info for 2024+ clip"}))});const t=5*allClips.length,n=e.issues.missingModel.length+e.issues.missingDuration.length+e.issues.missingTags.length+e.issues.missingImage.length+e.issues.unknownModel.length;return e.dataCompleteness=Math.max(0,Math.round(100*(1-n/t))),e}function renderValidationReport(e){const{issues:t,modelDistribution:n,totalClips:a,dataCompleteness:o}=e,s=Object.values(t).reduce((e,t)=>e+t.length,0),i=0===s?"ok":s<.1*a?"warn":"error";let l=`\n    <div class="validation-section">\n      <h4><span class="status-${i}">${"ok"===i?"✓":"warn"===i?"⚠️":"❌"}</span> Data Quality Overview</h4>\n      <div class="validation-stat">\n        <span class="validation-stat-label">Total Clips Analyzed</span>\n        <span class="validation-stat-value">${a.toLocaleString()}</span>\n      </div>\n      <div class="validation-stat">\n        <span class="validation-stat-label">Data Completeness</span>\n        <span class="validation-stat-value ${o>=90?"ok":o>=70?"warn":"error"}">${o}%</span>\n      </div>\n      <div class="validation-stat">\n        <span class="validation-stat-label">Total Issues Found</span>\n        <span class="validation-stat-value ${0===s?"ok":"warn"}">${s.toLocaleString()}</span>\n      </div>\n    </div>\n    \n    <div class="validation-section">\n      <h4>📊 Model Distribution</h4>\n      ${Object.entries(n).sort((e,t)=>t[1]-e[1]).map(([e,t])=>`\n          <div class="validation-stat">\n            <span class="validation-stat-label">${e}</span>\n            <span class="validation-stat-value">${t.toLocaleString()} (${(t/a*100).toFixed(1)}%)</span>\n          </div>\n        `).join("")}\n    </div>\n  `;const r=[{key:"potentiallyStale",label:"🕐 Potentially Stale Data",desc:"Clips that may need re-indexing"},{key:"unknownModel",label:"❓ Unknown Model Version",desc:"Could not determine model"},{key:"missingModel",label:"🤖 Missing Model Info",desc:"No model data at all"},{key:"missingDuration",label:"⏱️ Missing Duration",desc:"No duration metadata"},{key:"missingTags",label:"🏷️ Missing Tags",desc:"No genre/style tags"},{key:"missingImage",label:"🖼️ Missing Image",desc:"No cover art URL"}];for(const{key:e,label:n,desc:a}of r){const o=t[e];0!==o.length&&(l+=`\n      <div class="validation-section">\n        <h4><span class="status-warn">⚠️</span> ${n} (${o.length})</h4>\n        <p style="font-size: 12px; color: var(--text-muted); margin-bottom: 8px;">${a}</p>\n        <div class="validation-issues">\n          ${o.slice(0,20).map(e=>`\n            <div class="validation-issue">\n              <span class="validation-issue-title">${escapeHtml(e.title||"Untitled")}</span>\n              ${e.reason?`<span class="validation-issue-reason">${e.reason}</span>`:""}\n            </div>\n          `).join("")}\n          ${o.length>20?`<div class="validation-issue" style="color: var(--text-muted); font-style: italic;">...and ${o.length-20} more</div>`:""}\n        </div>\n      </div>\n    `)}const d=t.potentiallyStale.length>0,c=t.unknownModel.length>t.missingModel.length;return l+=`\n    <div class="validation-summary">\n      <h4>💡 Recommendations</h4>\n      <div class="validation-recommendation">\n        ${d?`\n          <p><strong>${t.potentiallyStale.length} clips</strong> may have been indexed with an older version that didn't capture all metadata.</p>\n          <p>To fix: <strong>Re-index your library</strong> from the popup. This will refresh metadata for all clips while preserving your custom names and definitive settings.</p>\n        `:""}\n        ${c&&!d?"\n          <p>Some clips have unrecognized model versions. This may indicate new Suno models not yet in our detection logic.</p>\n        ":""}\n        ${!d&&!c&&s>0?"\n          <p>Minor data gaps detected. These are often normal for older clips or uploads.</p>\n        ":""}\n        ${0===s?"\n          <p>✨ <strong>Your library data looks great!</strong> All clips have complete metadata.</p>\n        ":""}\n      </div>\n    </div>\n    \n    <div class="validation-section data-gaps-info">\n      <h4>ℹ️ About Data Gaps in Suno</h4>\n      <div class="data-gaps-explanation">\n        <p>Some data issues are <strong>Suno's limitations</strong>, not indexing problems:</p>\n        <ul>\n          <li><strong>Concat/Extended clips:</strong> Suno doesn't provide lineage for extended songs. Extensions show no parent reference.</li>\n          <li><strong>Older clips (pre-2024):</strong> May lack model version, tags, or other metadata added in later API versions.</li>\n          <li><strong>Stem separations:</strong> Often missing parent references despite clearly deriving from another clip.</li>\n          <li><strong>Cross-song covers:</strong> Parent references sometimes missing or pointing to inaccessible clips.</li>\n        </ul>\n        <p style="margin-top: 10px;">\n          <strong>Re-indexing won't fix these</strong> - the data simply doesn't exist in Suno's API. \n          Use <strong>Manual Links</strong> in the Library to connect orphaned clips to their source.\n        </p>\n        <p style="margin-top: 10px; color: var(--text-muted); font-size: 11px;">\n          For technical details, see the LINEAGE_DATA_GAPS.md documentation.\n        </p>\n      </div>\n    </div>\n  `,l}document.getElementById("modalClose")?.addEventListener("click",hideCustomNameModal),document.getElementById("modalCancel")?.addEventListener("click",hideCustomNameModal),document.getElementById("modalSave")?.addEventListener("click",saveCustomName),document.getElementById("modalClear")?.addEventListener("click",clearCustomNameFromModal),document.getElementById("customNameInput")?.addEventListener("keydown",e=>{"Enter"===e.key&&saveCustomName(),"Escape"===e.key&&hideCustomNameModal()}),document.getElementById("customNameModal")?.addEventListener("click",e=>{"customNameModal"===e.target.id&&hideCustomNameModal()}),document.getElementById("btnRefresh")?.addEventListener("click",loadData),document.getElementById("btnValidate")?.addEventListener("click",showValidationReport),document.getElementById("validationClose")?.addEventListener("click",hideValidationModal),document.getElementById("validationDismiss")?.addEventListener("click",hideValidationModal);let generatedCanvas=null;async function generateShareCard(){const e=document.getElementById("cardTheme")?.value||"midnight",t=document.getElementById("cardVariant")?.value||"full",n=gatherCardStats(),a=document.getElementById("wrappedPreview"),o=document.getElementById("wrappedDownload");a.innerHTML='<div class="preview-placeholder">✨ Generating your card...</div>';try{generatedCanvas=await ShareCard.generateCard(n,{theme:e,variant:t}),a.innerHTML="",a.appendChild(generatedCanvas),o.style.display="flex"}catch(e){a.innerHTML='<div class="preview-placeholder">❌ Failed to generate card</div>'}}function gatherCardStats(){const e=(clips||[]).filter(e=>e&&e.id),t=e.length,n=e.filter(e=>e?.is_liked).length;let a=0,o=null,s=0;e.forEach(e=>{const t=e?.metadata?.duration||0;a+=t,t>s&&(s=t,o=e)});const i=a/3600,l={};e.forEach(e=>{(e?.metadata?.tags||"").split(",").forEach(e=>{const t=e.trim().toLowerCase();t&&t.length>2&&(l[t]=(l[t]||0)+1)})});const r=Object.entries(l).sort((e,t)=>t[1]-e[1]).slice(0,5).map(([e,t])=>({name:e,count:t})),d={};clips.forEach(e=>{const t=getModelVersion(e);d[t]=(d[t]||0)+1});const c={};clips.forEach(e=>{const t=new Date(e.created_at).getHours();c[t]=(c[t]||0)+1});const u=Object.entries(c).sort((e,t)=>t[1]-e[1])[0]?.[0]||22,g=Object.entries(c).filter(([e])=>e>=22||e<6).reduce((e,[t,n])=>e+n,0),m=Array(12).fill(0);clips.forEach(e=>{const t=new Date(e.created_at).getMonth();m[t]++});let p=null,h=0,v=0;groupedSongs.forEach(e=>{v+=e.versions.length,e.versions.length>h&&!isUntitled(e.displayTitle)&&(h=e.versions.length,p=e.displayTitle)});const y=generateFunFactsList(),f=y[Math.floor(Math.random()*y.length)];return{totalSongs:t,likedSongs:n,totalDurationHours:i,topGenres:r,modelCounts:d,funFact:f,peakHour:parseInt(u),lateNightCount:g,monthlyBreakdown:m,mostVersionedSong:p,mostVersionedCount:h,totalVersions:v,longestDuration:s,longestSong:o?.title||"Unknown"}}function generateFunFactsList(){const e=clips.length,t=clips.filter(e=>e.is_liked).length,n=clips.filter(e=>"upload"===SunoOfflineDB.getClipType(e)).length,a=clips.filter(e=>SunoOfflineDB.isInstrumental(e)).length;let o=0;clips.forEach(e=>{o+=e.metadata?.duration||0});const s=Math.round(o/3600),i=[];return e>1e3&&i.push(`You've created over ${Math.floor(e/1e3)}K songs!`),n>10&&i.push(`${n} of your songs started from uploads`),a>.3*e&&i.push(`${Math.round(a/e*100)}% of your library is instrumentals`),t>500&&i.push(`You've favorited ${t} songs - great taste!`),s>100&&i.push(`That's ${s} hours of original music!`),0===i.length&&i.push(`You've created ${e} unique songs`),i}function downloadShareCard(){if(generatedCanvas){const e=`suno-wrapped-${document.getElementById("cardVariant")?.value||"full"}-${Date.now()}.png`;ShareCard.download(generatedCanvas,e)}}async function shareShareCard(){generatedCanvas&&await ShareCard.share(generatedCanvas,"My Suno Wrapped")}function initShareCard(){document.getElementById("btnGenerateCard")?.addEventListener("click",generateShareCard),document.getElementById("btnDownloadCard")?.addEventListener("click",downloadShareCard),document.getElementById("btnShareCard")?.addEventListener("click",shareShareCard),document.querySelectorAll(".wrapped-tab").forEach(e=>{e.addEventListener("click",()=>{document.querySelectorAll(".wrapped-tab").forEach(e=>e.classList.remove("active")),e.classList.add("active");const t=e.dataset.variant;document.getElementById("cardVariant").value=t,generatedCanvas&&generateShareCard()})}),document.getElementById("cardTheme")?.addEventListener("change",()=>{generatedCanvas&&generateShareCard()})}function initSectionNav(){const e=document.querySelectorAll(".nav-item"),t={hero:document.getElementById("heroSection"),wrapped:document.getElementById("wrappedSection"),achievements:document.getElementById("achievementsSection"),topSongs:document.getElementById("topSongsSection"),models:document.getElementById("modelsSection"),tags:document.getElementById("tagsSection"),genres:document.getElementById("genreExplorerSection"),dna:document.getElementById("dnaSection"),lineage:document.getElementById("lineageSection"),activity:document.getElementById("activitySection"),heatmap:document.getElementById("heatmapSection"),funFacts:document.getElementById("funFactsSection")};e.forEach(e=>{e.addEventListener("click",n=>{n.preventDefault();const a=e.dataset.section,o=t[a];o&&o.scrollIntoView({behavior:"smooth",block:"start"})})});let n=!1;function a(){const a=window.scrollY,o=window.innerHeight,s=a+.25*o;let i=null,l=1/0;Object.entries(t).forEach(([e,t])=>{if(!t)return;const n=t.getBoundingClientRect(),o=a+n.top,r=Math.abs(o-s);o<=s&&r<l&&(l=r,i=e)}),i||Object.entries(t).forEach(([e,t])=>{if(!t)return;const n=t.getBoundingClientRect(),o=a+n.top,r=Math.abs(o-s);r<l&&(l=r,i=e)}),i&&e.forEach(e=>{e.classList.toggle("active",e.dataset.section===i)}),n=!1}window.addEventListener("scroll",()=>{n||(requestAnimationFrame(a),n=!0)}),a()}document.addEventListener("DOMContentLoaded",async()=>{initPlayer(),initShareCard(),initSectionNav(),await loadCustomNames(),loadData()});