function showToast(e,t="info"){const n=document.querySelector(".toast");n&&n.remove();const o=document.createElement("div");o.className=`toast toast-${t}`,o.textContent=e,document.body.appendChild(o),setTimeout(()=>o.remove(),4e3)}async function sendMessage(e,t={}){return chrome.runtime.sendMessage({action:e,data:t})}function clearExtensionBadge(){try{chrome.action.setBadgeText({text:""}),chrome.action.setTitle({title:"Suno Explorer"})}catch(e){}}function downloadJson(e,t){const n=new Blob([JSON.stringify(e,null,2)],{type:"application/json"}),o=URL.createObjectURL(n),a=document.createElement("a");a.href=o,a.download=t,document.body.appendChild(a),a.click(),document.body.removeChild(a),URL.revokeObjectURL(o)}function formatDate(e){if(!e)return"Never";const t=new Date(e);return t.toLocaleDateString()+" "+t.toLocaleTimeString()}async function loadStats(){try{const e=await sendMessage("getLibraryMeta");document.getElementById("statClips").textContent=(e?.clipCount||0).toLocaleString(),document.getElementById("lastIndexed").textContent=formatDate(e?.lastIndexedAt);const t=await sendMessage("getDownloadStats");document.getElementById("statDownloaded").textContent=(t?.downloaded||0).toLocaleString();const n=((await chrome.storage.local.get("sunoOfflinePrefs")).sunoOfflinePrefs||{}).customNames||{},o=Object.keys(n).length;document.getElementById("statCustomNames").textContent=o.toLocaleString();let a=0;try{const e=await sendMessage("getAllManualLinks");a=Object.keys(e?.links||{}).length,document.getElementById("statManualLinks").textContent=a.toLocaleString()}catch(e){document.getElementById("statManualLinks").textContent="0"}const s=await chrome.storage.local.get(["lastBackupDate","lastBackupCounts"]);document.getElementById("lastBackup").textContent=formatDate(s.lastBackupDate);const r=document.getElementById("unsavedBadge");if(r){const e=s.lastBackupCounts||{},t={manualLinks:a,customNames:o},n=!s.lastBackupDate&&(t.manualLinks>0||t.customNames>0)||s.lastBackupDate&&(t.manualLinks!==(e.manualLinks||0)||t.customNames!==(e.customNames||0));r.style.display=n?"inline-block":"none"}}catch(e){showToast("Failed to load stats","error")}}document.getElementById("btnExportFull").addEventListener("click",async()=>{const e=document.getElementById("btnExportFull");e.disabled=!0,e.textContent="Exporting...";try{const e=await sendMessage("exportFullBackup");if(e?.error)throw new Error(e.error);const t=`suno-explorer-full-backup-${(new Date).toISOString().split("T")[0]}.json`;downloadJson(e.backup,t);const n=(await chrome.storage.local.get("sunoOfflinePrefs")).sunoOfflinePrefs||{},o=await sendMessage("getAllManualLinks"),a={manualLinks:Object.keys(o?.links||{}).length,customNames:Object.keys(n.customNames||{}).length};await chrome.storage.local.set({lastBackupDate:(new Date).toISOString(),lastBackupCounts:a}),document.getElementById("lastBackup").textContent=formatDate((new Date).toISOString());const s=document.getElementById("unsavedBadge");s&&(s.style.display="none"),clearExtensionBadge(),showToast(`Exported full backup (${e.backup.clips?.length||0} clips)`,"success")}catch(e){showToast(`Export failed: ${e.message}`,"error")}finally{e.disabled=!1,e.textContent="Export Full Backup"}}),document.getElementById("btnExportCuration").addEventListener("click",async()=>{const e=document.getElementById("btnExportCuration");e.disabled=!0,e.textContent="Exporting...";try{const e=await sendMessage("exportCurationData");if(e?.error)throw new Error(e.error);const t=`suno-explorer-curation-${(new Date).toISOString().split("T")[0]}.json`;downloadJson(e.curation,t);const n=(await chrome.storage.local.get("sunoOfflinePrefs")).sunoOfflinePrefs||{},o=await sendMessage("getAllManualLinks"),a={manualLinks:Object.keys(o?.links||{}).length,customNames:Object.keys(n.customNames||{}).length};await chrome.storage.local.set({lastBackupDate:(new Date).toISOString(),lastBackupCounts:a}),document.getElementById("lastBackup").textContent=formatDate((new Date).toISOString());const s=document.getElementById("unsavedBadge");s&&(s.style.display="none"),clearExtensionBadge(),showToast("Exported curation data","success")}catch(e){showToast(`Export failed: ${e.message}`,"error")}finally{e.disabled=!1,e.textContent="Export Curation"}}),document.getElementById("btnExportClips").addEventListener("click",async()=>{const e=document.getElementById("btnExportClips");e.disabled=!0,e.textContent="Exporting...";try{const e=await sendMessage("exportLibrary");if(e?.error)throw new Error(e.error);const t=`suno-clips-${(new Date).toISOString().split("T")[0]}.json`;downloadJson({clips:e.clips,exportedAt:(new Date).toISOString()},t),showToast(`Exported ${e.clips?.length||0} clips`,"success")}catch(e){showToast(`Export failed: ${e.message}`,"error")}finally{e.disabled=!1,e.textContent="Export Clips JSON"}}),document.getElementById("btnImportFull").addEventListener("click",()=>{document.getElementById("importFullInput").click()}),document.getElementById("importFullInput").addEventListener("change",async e=>{const t=e.target.files?.[0];if(t){try{const e=await t.text(),n=JSON.parse(e),o=document.getElementById("mergeMode").checked;showToast("Importing backup...","info");const a=await sendMessage("importFullBackup",{backup:n,merge:o});if(a?.error)throw new Error(a.error);showToast("Imported backup successfully","success"),loadStats()}catch(e){showToast(`Import failed: ${e.message}`,"error")}e.target.value=""}}),document.getElementById("btnImportCuration").addEventListener("click",()=>{document.getElementById("importCurationInput").click()}),document.getElementById("importCurationInput").addEventListener("change",async e=>{const t=e.target.files?.[0];if(t){try{const e=await t.text(),n=JSON.parse(e),o=document.getElementById("mergeMode").checked,a=await sendMessage("importCurationData",{curation:n,merge:o});if(a?.error)throw new Error(a.error);showToast("Imported curation data","success"),loadStats()}catch(e){showToast(`Import failed: ${e.message}`,"error")}e.target.value=""}}),document.getElementById("btnImportClips").addEventListener("click",()=>{document.getElementById("importClipsInput").click()}),document.getElementById("importClipsInput").addEventListener("change",async e=>{const t=e.target.files?.[0];if(t){try{const e=await t.text(),n=JSON.parse(e),o=n.clips||(Array.isArray(n)?n:null);if(!o)throw new Error("No clips found in file");const a=await sendMessage("importLibrary",{clips:o,meta:{source:"manual-import",exportedAt:n.exportedAt,downloadRecords:n.downloadRecords}});if(a?.error)throw new Error(a.error);showToast(`Imported ${a.imported||o.length} clips`,"success"),loadStats()}catch(e){showToast(`Import failed: ${e.message}`,"error")}e.target.value=""}}),document.getElementById("btnRecoveryTool").addEventListener("click",()=>{const e=chrome.runtime.getURL("tools/recover-from-files.html");chrome.tabs.create({url:e})}),document.getElementById("btnReIndex").addEventListener("click",async()=>{const e=document.getElementById("btnReIndex");if(confirm("This will re-fetch your entire library from Suno. Continue?")){e.disabled=!0,e.textContent="Opening Suno...";try{const e=await chrome.tabs.query({url:"https://suno.com/*"});0===e.length?(await chrome.tabs.create({url:"https://suno.com"}),showToast("Open the extension popup on suno.com to start indexing","info")):(await chrome.tabs.update(e[0].id,{active:!0}),showToast("Use the extension popup to start indexing","info"))}catch(e){showToast(`Failed: ${e.message}`,"error")}finally{e.disabled=!1,e.textContent="Re-Index Library"}}}),document.getElementById("btnClearDownloads").addEventListener("click",async()=>{if(confirm("Clear download history? Your files stay on disk, but the extension forgets what's downloaded."))try{await sendMessage("clearDownloadHistory"),showToast("Download history cleared","success"),loadStats()}catch(e){showToast(`Failed: ${e.message}`,"error")}}),document.getElementById("btnClearCuration").addEventListener("click",async()=>{if(confirm("Clear all curation data? This removes custom names, manual links, and definitive versions."))try{const{sunoOfflineSettings:e={}}=await chrome.storage.local.get("sunoOfflineSettings");delete e.customNames,delete e.definitiveVersions,delete e.visibility,delete e.externalLinks,delete e.hideUnliked,delete e.customArt,await chrome.storage.local.set({sunoOfflineSettings:e}),await sendMessage("clearAllManualLinks"),showToast("Curation data cleared","success"),loadStats()}catch(e){showToast(`Failed: ${e.message}`,"error")}}),document.getElementById("btnClearAll").addEventListener("click",async()=>{if(confirm("⚠️ NUCLEAR OPTION: Clear ALL data? This cannot be undone!")&&confirm("Are you absolutely sure? This will reset everything."))try{await sendMessage("clearLibrary"),await sendMessage("clearDownloadHistory"),await chrome.storage.local.clear(),showToast("All data cleared. Extension reset.","success"),loadStats()}catch(e){showToast(`Failed: ${e.message}`,"error")}}),document.getElementById("btnRefreshStats").addEventListener("click",()=>{loadStats(),showToast("Stats refreshed","info")}),loadStats();