const LOG_LEVELS={DEBUG:0,INFO:1,WARN:2,ERROR:3};function createLogger(e){return{debug:(e,t)=>{},info:(e,t)=>{},warn:(e,t)=>{},error:(e,t)=>{}}}const log=createLogger("Background");let state={token:null,library:{clips:[],lastIndexedAt:null,indexInProgress:!1,clipCount:0,feed:{pagesIndexed:0,totalEstimate:null,complete:!1},liked:{pagesIndexed:0,totalEstimate:null,complete:!1}},syncHistory:[],config:{speed:"balanced",downloadPath:"SunoExplorer",includeStems:!1}};const DB_NAME="SunoOfflineDB",DB_VERSION=3,CLIPS_STORE="clips",DOWNLOADS_STORE="downloads",MANUAL_LINKS_STORE="manualLinks";let db=null;async function openDatabase(){return db||(log.debug(`Opening database ${DB_NAME} v3...`),new Promise((e,t)=>{const o=indexedDB.open(DB_NAME,3);o.onerror=()=>{log.error("Failed to open IndexedDB",o.error),t(o.error)},o.onblocked=()=>{log.warn("Database upgrade blocked - close other tabs/windows using this extension")},o.onsuccess=()=>{db=o.result,log.info(`IndexedDB opened successfully (v${db.version}, stores: ${Array.from(db.objectStoreNames).join(", ")})`),e(db)},o.onupgradeneeded=e=>{const t=e.target.result;if(!t.objectStoreNames.contains("clips")){const e=t.createObjectStore("clips",{keyPath:"id"});e.createIndex("created_at","created_at",{unique:!1}),e.createIndex("is_liked","is_liked",{unique:!1}),e.createIndex("title","title",{unique:!1}),log.info("Created clips object store")}if(!t.objectStoreNames.contains("downloads")){const e=t.createObjectStore("downloads",{keyPath:"clipId"});e.createIndex("downloadedAt","downloadedAt",{unique:!1}),e.createIndex("status","status",{unique:!1}),log.info("Created downloads object store")}if(!t.objectStoreNames.contains("manualLinks")){const e=t.createObjectStore("manualLinks",{keyPath:"childId"});e.createIndex("parentId","parentId",{unique:!1}),e.createIndex("linkedAt","linkedAt",{unique:!1}),log.info("Created manual links object store")}}}))}async function saveClipsToDB(e){const t=await openDatabase();return new Promise((o,a)=>{const r=t.transaction(["clips"],"readwrite"),n=r.objectStore("clips");let s=0;for(const t of e)n.put(t),s++;r.oncomplete=()=>{log.debug(`Saved ${s} clips to IndexedDB`),o(s)},r.onerror=()=>{log.error("Failed to save clips to IndexedDB",r.error),a(r.error)}})}async function loadClipsFromDB(){const e=await openDatabase();return new Promise((t,o)=>{const a=e.transaction(["clips"],"readonly").objectStore("clips").getAll();a.onsuccess=()=>{log.info(`Loaded ${a.result.length} clips from IndexedDB`),t(a.result)},a.onerror=()=>{log.error("Failed to load clips from IndexedDB",a.error),o(a.error)}})}async function getClipCountFromDB(){const e=await openDatabase();return new Promise((t,o)=>{const a=e.transaction(["clips"],"readonly").objectStore("clips").count();a.onsuccess=()=>t(a.result),a.onerror=()=>o(a.error)})}async function markAsDownloaded(e,t,o=0){const a=await openDatabase();return new Promise((r,n)=>{const s=a.transaction(["downloads"],"readwrite");s.objectStore("downloads").put({clipId:e,filename:t,filesize:o,downloadedAt:(new Date).toISOString(),status:"complete"}),s.oncomplete=()=>r(!0),s.onerror=()=>n(s.error)})}async function getDownloadedClipIds(){const e=await openDatabase();return new Promise((t,o)=>{const a=e.transaction(["downloads"],"readonly").objectStore("downloads").getAllKeys();a.onsuccess=()=>t(new Set(a.result)),a.onerror=()=>o(a.error)})}async function getDownloadStats(){try{const e=await openDatabase();return e.objectStoreNames.contains("downloads")?new Promise((t,o)=>{const a=e.transaction(["downloads"],"readonly").objectStore("downloads").getAll();a.onsuccess=()=>{const e=a.result;log.debug(`getDownloadStats: found ${e.length} download records`);const o=e.reduce((e,t)=>e+(t.filesize||0),0);t({downloaded:e.length,totalSize:o,lastDownload:e.length>0?e.sort((e,t)=>new Date(t.downloadedAt)-new Date(e.downloadedAt))[0]:null})},a.onerror=()=>o(a.error)}):(log.warn("Downloads store does not exist!"),{downloaded:0,totalSize:0,lastDownload:null})}catch(e){return log.error("Failed to get download stats:",e),{downloaded:0,totalSize:0,lastDownload:null}}}async function clearDownloadHistory(){const e=await openDatabase();return new Promise((t,o)=>{const a=e.transaction(["downloads"],"readwrite");a.objectStore("downloads").clear(),a.oncomplete=()=>t(!0),a.onerror=()=>o(a.error)})}async function getDatabaseDiagnostics(){try{const e=await openDatabase(),t=Array.from(e.objectStoreNames),o={version:e.version,stores:t,storeCounts:{}};for(const a of t)try{const t=await new Promise((t,o)=>{const r=e.transaction([a],"readonly").objectStore(a).count();r.onsuccess=()=>t(r.result),r.onerror=()=>o(r.error)});o.storeCounts[a]=t}catch(e){o.storeCounts[a]=`Error: ${e.message}`}return log.info("Database diagnostics:",o),o}catch(e){return log.error("Failed to get database diagnostics:",e),{error:e.message}}}async function setManualLink(e,t){try{const o=await openDatabase();if(!o.objectStoreNames.contains("manualLinks"))return log.error("Manual links store does not exist"),!1;try{await chrome.storage.local.set({lastCurationModified:(new Date).toISOString()})}catch(e){}return new Promise((a,r)=>{const n=o.transaction(["manualLinks"],"readwrite");n.objectStore("manualLinks").put({childId:e,parentId:t,linkedAt:(new Date).toISOString()}),n.oncomplete=()=>{log.info(`Manual link created: ${e.slice(0,8)} → ${t.slice(0,8)}`),a(!0)},n.onerror=()=>r(n.error)})}catch(e){return log.error("Failed to set manual link:",e),!1}}async function removeManualLink(e){try{const t=await openDatabase();return t.objectStoreNames.contains("manualLinks")?new Promise((o,a)=>{const r=t.transaction(["manualLinks"],"readwrite");r.objectStore("manualLinks").delete(e),r.oncomplete=()=>{log.info(`Manual link removed for: ${e.slice(0,8)}`),o(!0)},r.onerror=()=>a(r.error)}):(log.error("Manual links store does not exist"),!1)}catch(e){return log.error("Failed to remove manual link:",e),!1}}async function getManualLink(e){const t=await openDatabase();return new Promise((o,a)=>{const r=t.transaction(["manualLinks"],"readonly").objectStore("manualLinks").get(e);r.onsuccess=()=>o(r.result||null),r.onerror=()=>a(r.error)})}async function getAllManualLinks(){try{const e=await openDatabase();return e.objectStoreNames.contains("manualLinks")?new Promise((t,o)=>{const a=e.transaction(["manualLinks"],"readonly").objectStore("manualLinks").getAll();a.onsuccess=()=>{const e={};for(const t of a.result)e[t.childId]=t.parentId;t(e)},a.onerror=()=>o(a.error)}):(log.debug("Manual links store does not exist yet"),{})}catch(e){return log.error("Failed to get manual links:",e),{}}}async function getUploadsBeforeDate(e){const t=await loadClipsFromDB();log.debug(`getUploadsBeforeDate: beforeDate=${e}, total clips=${t.length}`);let o=t.filter(e=>"upload"===e.metadata?.type);if(log.debug(`Found ${o.length} uploads total`),e){const t=new Date(e);o=o.filter(e=>new Date(e.created_at)<t),log.debug(`Filtered to ${o.length} uploads before ${t.toISOString()}`)}return o.sort((e,t)=>new Date(t.created_at)-new Date(e.created_at)),o}async function getClipIdsFromDB(){const e=await openDatabase();return new Promise((t,o)=>{const a=e.transaction(["clips"],"readonly").objectStore("clips").getAllKeys();a.onsuccess=()=>t(new Set(a.result)),a.onerror=()=>o(a.error)})}async function clearClipsFromDB(){const e=await openDatabase();return new Promise((t,o)=>{const a=e.transaction(["clips"],"readwrite").objectStore("clips").clear();a.onsuccess=()=>{log.info("Cleared all clips from IndexedDB"),t()},a.onerror=()=>o(a.error)})}async function loadState(){try{const e=await chrome.storage.local.get(["sunoOfflineConfig"]);if(e.sunoOfflineConfig){state.token=e.sunoOfflineConfig.token,state.library.lastIndexedAt=e.sunoOfflineConfig.lastIndexedAt,state.library.feed=e.sunoOfflineConfig.feed||state.library.feed,state.library.liked=e.sunoOfflineConfig.liked||state.library.liked,state.syncHistory=e.sunoOfflineConfig.syncHistory||[];const t=e.sunoOfflineConfig.config||{};state.config={speed:t.speed||"balanced",downloadPath:t.downloadPath||"SunoExplorer",includeStems:t.includeStems||!1},log.info("Loaded config:",state.config)}try{await openDatabase(),state.library.clipCount=await getClipCountFromDB(),log.info("State loaded",{clipCount:state.library.clipCount,hasToken:!!state.token,lastIndexed:state.library.lastIndexedAt,speed:state.config?.speed})}catch(e){log.warn("Could not load clip count from IndexedDB",e)}}catch(e){log.error("Failed to load state",e)}}async function saveState(){try{await chrome.storage.local.set({sunoOfflineConfig:{token:state.token,lastIndexedAt:state.library.lastIndexedAt,feed:state.library.feed,liked:state.library.liked,syncHistory:state.syncHistory,config:state.config}}),log.debug("Config saved to chrome.storage")}catch(e){log.error("Failed to save state",e)}}async function saveLibraryMeta(){try{const e=(await chrome.storage.local.get(["sunoOfflineConfig"])).sunoOfflineConfig||{};e.lastIndexedAt=state.library.lastIndexedAt,e.feed=state.library.feed,e.liked=state.library.liked,e.clipCount=state.library.clipCount,await chrome.storage.local.set({sunoOfflineConfig:e})}catch(e){log.error("Failed to save library meta",e)}}async function migrateFromChromeStorage(){try{const e=await chrome.storage.local.get(["sunoOfflineState"]);e.sunoOfflineState?.library?.clips?.length>0&&(log.info(`Migrating ${e.sunoOfflineState.library.clips.length} clips to IndexedDB...`),await saveClipsToDB(e.sunoOfflineState.library.clips),await chrome.storage.local.set({sunoOfflineConfig:{token:e.sunoOfflineState.token,lastIndexedAt:e.sunoOfflineState.library.lastIndexedAt,feed:e.sunoOfflineState.library.feed,liked:e.sunoOfflineState.library.liked,syncHistory:e.sunoOfflineState.syncHistory}}),await chrome.storage.local.remove(["sunoOfflineState"]),log.info("Migration complete!"))}catch(e){log.error("Migration failed",e)}}const BASE_URL="https://studio-api.prod.suno.com/api",SPEED_PRESETS={slow:{label:"Slow",tooltip:"Conservative - minimal network impact, ~3s between requests",apiDelay:3e3,downloadDelay:2e3,concurrentDownloads:1},balanced:{label:"Balanced",tooltip:"Moderate pace - good balance of speed and stability",apiDelay:500,downloadDelay:200,concurrentDownloads:2},fast:{label:"Fast",tooltip:"Aggressive - fastest but may cause rate limits or network issues",apiDelay:100,downloadDelay:50,concurrentDownloads:3}};function getSpeedPreset(){const e=state.config?.speed||"balanced";return SPEED_PRESETS[e]||SPEED_PRESETS.balanced}let lastRequest=0;async function apiRateLimit(){const e=getSpeedPreset().apiDelay,t=Date.now()-lastRequest;t<e&&await new Promise(o=>setTimeout(o,e-t)),lastRequest=Date.now()}async function apiFetch(e){if(!state.token)throw log.error("apiFetch called but no token! Token state:",!!state.token),broadcastDisconnected("No token"),new Error("No auth token - please reconnect on suno.com");await apiRateLimit();const t=e.startsWith("http")?e:`${BASE_URL}${e}`;log.info(`API Request: ${t}`);const o=await fetch(t,{headers:{Authorization:`Bearer ${state.token}`,"Content-Type":"application/json"}});if(log.info(`API Response: ${o.status} ${o.statusText}`),!o.ok){if(401===o.status)throw state.token=null,await saveState(),broadcastDisconnected("Token expired"),new Error("Token expired - please reconnect on suno.com");if(429===o.status)return log.warn("Rate limited, waiting 5s..."),await new Promise(e=>setTimeout(e,5e3)),apiFetch(e);throw new Error(`API error: ${o.status}`)}const a=await o.json();return log.debug("API Response data keys:",Object.keys(a)),a}async function getAllFeed(e){const t=[];let o=0,a=!0;for(;a;){const r=new URLSearchParams({hide_disliked:"false",hide_gen_stems:state.config.includeStems?"false":"true",hide_studio_clips:"true",page:o.toString()}),n=await apiFetch(`/feed/v2?${r}`),s=n.clips||[];t.push(...s),a=n.has_more&&s.length>0,e&&e("feed",o,t.length,n.num_total_results),log.info(`Feed page ${o}: ${s.length} clips`),o++}return t}async function getAllLiked(e,t=null){const o=[];let a=1,r=!0,n=0;for(;r;){const s=await apiFetch(`/playlist/liked/?page=${a}`),i=(s.playlist_clips||[]).map(e=>{const t=e.clip||e;return t.is_liked=!0,t});for(const e of i)t&&e.user_id!==t?n++:o.push(e);r=i.length>0,e&&e("liked",a,o.length,s.num_total_results),log.info(`Liked page ${a}: ${i.length} clips (${n} from other users skipped)`),a++}return n>0&&log.info(`Total liked clips from other users skipped: ${n}`),o}const SUFFIX_PATTERNS=[/\s*\(Cover\)\s*$/i,/\s*\(Remaster(?:ed)?\s*(?:x\d+)?\)\s*$/i,/\s*\(Extended\)\s*$/i,/\s*\(Remix\)\s*$/i,/\s*v\d+\s*$/i,/\s*x\d+\s*$/i,/\s*#\d+\s*$/i,/\s*-\s*\d+\s*$/,/\s*\(\d+\)\s*$/];function normalizeTitle(e){if(!e)return"Untitled";let t=e.trim(),o=!0,a=0;for(;o&&a<20;){o=!1,a++;for(const e of SUFFIX_PATTERNS){const a=t.replace(e,"").trim();a!==t&&a.length>0&&(t=a,o=!0)}}return t||"Untitled"}function sanitizeFilename(e){return e&&e.replace(/[<>:"/\\|?*\x00-\x1F]/g,"_").replace(/[^\x20-\x7E]/g,"").replace(/\s+/g," ").replace(/^\.+/,"").replace(/\.+$/,"").trim().slice(0,180)||"Untitled"}function processClips(e){const t=new Map;for(const o of e){const e=normalizeTitle(o.title);t.has(e)||t.set(e,[]),t.get(e).push(o)}const o=[];for(const[e,a]of t)[...a].sort((e,t)=>new Date(e.created_at)-new Date(t.created_at)).forEach((t,r)=>{o.push({...t,_version:a.length>1?r+1:null,_versionTotal:a.length,_baseTitle:e})});return log.info(`Processed ${e.length} clips into ${t.size} unique songs`),o}function getFilename(e){const t=sanitizeFilename(e._baseTitle||normalizeTitle(e.title)),o=e.id?e.id.substring(0,8):"",a=e._version?` [${e._version}]`:"";return o?`${t}${a} (${o})`:`${t}${a}`}let downloadProgress={phase:"idle",current:0,total:0,errors:[]},isDownloading=!1;const DOWNLOAD_SETTINGS={maxRetries:3,baseRetryDelay:2e3,maxRetryDelay:3e4,consecutiveErrorThreshold:5,pauseOnErrorDuration:1e4,getDownloadDelay:()=>getSpeedPreset().downloadDelay};let consecutiveErrors=0;async function checkNetworkConnectivity(){try{return(await fetch("https://suno.com/favicon.ico",{method:"HEAD",cache:"no-store"})).ok}catch{return!1}}function getRetryDelay(e){return Math.min(DOWNLOAD_SETTINGS.baseRetryDelay*Math.pow(2,e),DOWNLOAD_SETTINGS.maxRetryDelay)*(.8+.4*Math.random())}async function sleep(e){return new Promise(t=>setTimeout(t,e))}async function downloadFromUrl(e,t){return new Promise((o,a)=>{let r=null,n=null,s=!1;const i=e=>{if(e.id===r){if("complete"===e.state?.current&&(l(),chrome.downloads.search({id:r},e=>{const t=e[0]?.fileSize||0;o({downloadId:r,fileSize:t})})),"interrupted"===e.state?.current){l();const t=e.error?.current||"Download interrupted";a(new Error(`Download failed: ${t}`))}e.error?.current&&(l(),a(new Error(`Download error: ${e.error.current}`)))}},l=()=>{s||(s=!0,chrome.downloads.onChanged.removeListener(i),n&&clearTimeout(n))};chrome.downloads.onChanged.addListener(i),chrome.downloads.download({url:e,filename:t,saveAs:!1,conflictAction:"overwrite"},e=>{if(chrome.runtime.lastError)return l(),void a(new Error(chrome.runtime.lastError.message));r=e,n=setTimeout(()=>{s||(l(),chrome.downloads.cancel(r),a(new Error("Download timeout (5 min)")))},3e5)})})}async function downloadText(e,t,o="application/json"){return new Promise((a,r)=>{const n=btoa(unescape(encodeURIComponent(e))),s=`data:${o};base64,${n}`;chrome.downloads.download({url:s,filename:t,saveAs:!1,conflictAction:"uniquify"},e=>{chrome.runtime.lastError?r(new Error(chrome.runtime.lastError.message)):setTimeout(()=>a(e),50)})})}async function testDownloadSettings(){return new Promise(e=>{const t=`data:text/plain;base64,${btoa("Suno Explorer test file - you can delete this")}`;let o=null,a=!1;const r=setTimeout(()=>{a||(a=!0,o&&(chrome.downloads.cancel(o),chrome.downloads.erase({id:o})),e({success:!1,reason:"timeout",message:'Download prompt may be enabled. Please disable "Ask where to save" in Chrome settings.'}))},3e3);chrome.downloads.download({url:t,filename:"SunoOffline/test-download.txt",saveAs:!1,conflictAction:"overwrite"},t=>{if(chrome.runtime.lastError)return clearTimeout(r),a=!0,void e({success:!1,reason:"error",message:chrome.runtime.lastError.message});o=t;const n=()=>{chrome.downloads.search({id:o},t=>{if(!a&&t&&t[0]){const n=t[0];"complete"===n.state?(clearTimeout(r),a=!0,chrome.downloads.erase({id:o}),e({success:!0})):"interrupted"===n.state&&(clearTimeout(r),a=!0,e({success:!1,reason:n.error||"interrupted",message:"Download was interrupted"}))}})};setTimeout(n,500),setTimeout(n,1500),setTimeout(n,2500)})})}async function downloadClipWithRetry(e,t="SunoOffline",o=0){try{const o=await downloadClip(e,t);return consecutiveErrors=0,o}catch(a){if(consecutiveErrors++,o<DOWNLOAD_SETTINGS.maxRetries){const r=getRetryDelay(o);return log.warn(`Download failed for ${e.title}, retrying in ${Math.round(r/1e3)}s (attempt ${o+1}/${DOWNLOAD_SETTINGS.maxRetries})`,a.message),await checkNetworkConnectivity()?await sleep(r):(log.warn("Network appears to be down, waiting longer..."),await sleep(DOWNLOAD_SETTINGS.pauseOnErrorDuration)),downloadClipWithRetry(e,t,o+1)}throw a}}async function downloadClip(e,t="SunoOffline"){const o=getFilename(e),a=`${t}/Songs/${sanitizeFilename(e._baseTitle||e.title||"Untitled")}`;log.info(`Downloading: ${o} to ${a}`);const r={id:e.id,title:e.title,displayTitle:o,baseTitle:e._baseTitle,version:e._version,versionTotal:e._versionTotal,createdAt:e.created_at,duration:e.metadata?.duration,tags:e.metadata?.tags,prompt:e.metadata?.prompt,model:e.major_model_version,isLiked:e.is_liked,audioUrl:e.audio_url,imageUrl:e.image_url};let n=0;if(!e.audio_url)throw new Error(`No audio URL for clip ${e.id}`);try{n=(await downloadFromUrl(e.audio_url,`${a}/${o}.mp3`)).fileSize||0,n<1e4&&log.warn(`Audio file for ${o} is suspiciously small (${n} bytes)`)}catch(e){throw log.error(`Failed to download audio for ${o}:`,e),e}const s=e.image_large_url||e.image_url;if(s)try{await downloadFromUrl(s,`${a}/${o}.jpg`)}catch(e){log.warn(`Failed to download image for ${o}:`,e)}try{await downloadText(JSON.stringify(r,null,2),`${a}/${o}.json`,"application/json")}catch(e){log.warn(`Failed to save metadata for ${o}:`,e)}if(await markAsDownloaded(e.id,o,n),e.metadata?.prompt)try{await downloadText(e.metadata.prompt,`${a}/${o}.txt`,"text/plain")}catch(e){log.warn(`Failed to save lyrics for ${o}:`,e)}return r}async function syncAll(e={}){if(isDownloading)return{success:!1,error:"Already syncing"};isDownloading=!0,downloadProgress={phase:"fetching",current:0,total:0,errors:[]};const{includeFeed:t=!0,includeLiked:o=!0,downloadPath:a="SunoExplorer",dateFilter:r="all",modelFilter:n="all",durationFilter:s="all",creatorFilter:i="all",likedOnly:l=!1,limit:d=0}=e,c=a||"SunoOffline",u=d>0;log.info("Sync options:",{includeFeed:t,includeLiked:o,basePath:c,limit:d,isPreview:u,dateFilter:r,creatorFilter:i});try{let e=[];if(u){downloadProgress.phase="fetching-preview",downloadProgress.total=d,broadcastProgress();const a=Math.ceil(d/20);if(t)for(let t=0;t<a&&e.length<d;t++){const o=new URLSearchParams({hide_disliked:"false",hide_gen_stems:state.config.includeStems?"false":"true",hide_studio_clips:"true",page:t.toString()}),a=await apiFetch(`/feed/v2?${o}`);e.push(...a.clips||[]),downloadProgress.current=Math.min(e.length,d),broadcastProgress()}if(o&&e.length<d){e.length;const t=await apiFetch("/playlist/liked/?page=1"),o=new Set(e.map(e=>e.id));for(const a of t.playlist_clips||[]){const t=a.clip||a;t.is_liked=!0,!o.has(t.id)&&e.length<d&&e.push(t)}}e=e.slice(0,d),log.info(`Preview: fetched ${e.length} clips`)}else{const t=await loadClipsFromDB();if(!(t&&t.length>0))return downloadProgress.phase="error",broadcastProgress(),{success:!1,error:'Please index your library first using the "Index Library" button'};log.info(`Using indexed library: ${t.length} clips`);for(const o of t)i&&"all"!==i&&o.user_id!==i||e.push(o);log.info(`After creator filter: ${e.length} clips`)}let a=e;if("all"!==r){const t=new Date;let o;switch(r){case"week":o=new Date(t-6048e5);break;case"month":o=new Date(t-2592e6);break;case"3months":o=new Date(t-7776e6);break;case"year":o=new Date(t-31536e6)}o&&(a=a.filter(e=>new Date(e.created_at)>=o),log.info(`Date filter: ${a.length}/${e.length} clips after ${r}`))}"all"!==n&&(a=a.filter(e=>e.model_name===n),log.info(`Model filter: ${a.length} clips for ${n}`)),"all"!==s&&(a=a.filter(e=>{const t=e.metadata?.duration||0;switch(s){case"short":return t<120;case"medium":return t>=120&&t<=240;case"long":return t>240;default:return!0}}),log.info(`Duration filter: ${a.length} clips for ${s}`)),l&&(a=a.filter(e=>e.is_liked),log.info(`Liked only filter: ${a.length} clips`)),downloadProgress.phase="processing",broadcastProgress();const g=processClips(a),p=await getDownloadedClipIds(),f=g.filter(e=>!p.has(e.id)),m=g.length-f.length;log.info(`Download: ${f.length} new, ${m} already downloaded`),downloadProgress.phase="downloading",downloadProgress.current=0,downloadProgress.total=f.length,downloadProgress.skipped=m,downloadProgress.totalWithSkipped=g.length,broadcastProgress();let w=0;for(const e of f){if(!isDownloading){downloadProgress.phase="paused",downloadProgress.pausedAt=w,broadcastProgress();break}try{await downloadClipWithRetry(e,c),w++,downloadProgress.current=w,downloadProgress.currentClip=e,downloadProgress.currentTitle=e.title||"Untitled",broadcastProgress(),await sleep(DOWNLOAD_SETTINGS.getDownloadDelay())}catch(t){if(log.error(`Failed to download ${e.id} after retries`,t),downloadProgress.errors.push({id:e.id,title:e.title,error:t.message}),consecutiveErrors>=DOWNLOAD_SETTINGS.consecutiveErrorThreshold){if(log.warn(`Hit ${consecutiveErrors} consecutive errors, pausing downloads...`),downloadProgress.phase="paused",downloadProgress.pauseReason="Multiple consecutive errors - possible network issue",broadcastProgress(),await sleep(DOWNLOAD_SETTINGS.pauseOnErrorDuration),!await checkNetworkConnectivity()){log.warn("Network still down, waiting longer..."),downloadProgress.pauseReason="Network appears to be down - waiting for reconnection",broadcastProgress();let e=0;for(;!await checkNetworkConnectivity()&&e<60&&isDownloading;)await sleep(5e3),e++;if(!isDownloading)return{success:!1,error:"Download cancelled"}}consecutiveErrors=0,downloadProgress.phase="downloading",downloadProgress.pauseReason=null,broadcastProgress(),log.info("Resuming downloads...")}}}return isDownloading&&g.length>0&&await generateLibraryJson(g,c),downloadProgress.phase="complete",broadcastProgress(),state.syncHistory=state.syncHistory||[],state.syncHistory.unshift({startedAt:(new Date).toISOString(),downloaded:w,total:g.length,preview:u}),state.syncHistory=state.syncHistory.slice(0,20),await saveState(),{success:!0,downloaded:w,total:g.length}}catch(e){return log.error("Sync failed",e),downloadProgress.phase="error",broadcastProgress(),{success:!1,error:e.message}}finally{isDownloading=!1}}async function generateLibraryJson(e,t="SunoOffline"){const o=e.reduce((e,t)=>e+(t.metadata?.duration||0),0),a=Math.floor(o/3600),r=Math.floor(o%3600/60),n=new Set(e.map(e=>e._baseTitle)).size,s={version:"1.0.0",generatedAt:(new Date).toISOString(),basePath:t,stats:{totalClips:e.length,uniqueSongs:n,totalDurationSeconds:o,totalDurationFormatted:a>0?`${a}h ${r}m`:`${r}m`},songs:e.map(e=>{const t=sanitizeFilename(e._baseTitle||e.title),o=getFilename(e);return{id:e.id,title:e.title,displayTitle:o,baseTitle:e._baseTitle,version:e._version,versionTotal:e._versionTotal,createdAt:e.created_at,duration:e.metadata?.duration,tags:e.metadata?.tags,lyrics:e.metadata?.prompt,model:e.major_model_version,modelName:e.model_name,isLiked:e.is_liked,localPath:`Songs/${t}/${o}.mp3`,imagePath:`Songs/${t}/${o}.jpg`}})};log.info(`Library: ${e.length} songs, ${n} unique, ${s.stats.totalDurationFormatted}`),await downloadText(JSON.stringify(s,null,2),`${t}/library.json`,"application/json");try{const e=chrome.runtime.getURL("player/player.html"),o=await fetch(e),a=await o.text();await downloadText(a,`${t}/player.html`,"text/html"),log.info("Player exported to",`${t}/player.html`)}catch(e){log.warn("Could not export player",e)}}function broadcastProgress(){chrome.runtime.sendMessage({action:"syncProgress",progress:downloadProgress}).catch(()=>{})}function broadcastDisconnected(e){log.warn(`Broadcasting disconnection: ${e}`),chrome.runtime.sendMessage({action:"disconnected",reason:e}).catch(()=>{})}function getUserInfoFromToken(){if(!state.token)return{error:"Not connected"};try{const e=state.token.split(".");if(3!==e.length)return{error:"Invalid token format"};const t=JSON.parse(atob(e[1].replace(/-/g,"+").replace(/_/g,"/"))),o=t["https://suno.ai/claims/email"]||null,a=t["https://suno.ai/claims/clerk_id"]||t.sub||null;let r=null;return o?r=o.split("@")[0]:a&&(r=a.substring(0,8)),{email:o,clerkId:a,handle:r,expiresAt:t.exp?new Date(1e3*t.exp).toISOString():null}}catch(e){return log.error("Failed to decode token:",e),{error:"Failed to decode token"}}}async function extractTokenFromTab(e){log.info("Extracting token from tab:",e);try{const t=await chrome.scripting.executeScript({target:{tabId:e},world:"MAIN",func:async()=>{let e=0;for(;(!window.Clerk||!window.Clerk.session)&&e<20;)await new Promise(e=>setTimeout(e,500)),e++;if(!window.Clerk||!window.Clerk.session)return{success:!1,error:"Clerk not available - are you logged in?"};try{return{success:!0,token:await window.Clerk.session.getToken()}}catch(e){return{success:!1,error:e.message}}}});if(t&&t[0]&&t[0].result){const e=t[0].result;if(e.success&&e.token){const t=getUserInfoFromToken(),o=t?.clerkId;state.token=e.token;const a=getUserInfoFromToken(),r=a?.clerkId;return o&&r&&o!==r?(log.warn(`Account switched! Old: ${o?.substring(0,8)}, New: ${r?.substring(0,8)}`),{success:!0,warning:"different_account",message:`You connected as @${a.handle||"unknown"}, but indexed data is for a different account. Clear library or use a separate Chrome profile for multi-account.`,oldUser:t.handle,newUser:a.handle}):(await saveState(),log.info("Token extracted and saved!",{user:a?.handle}),{success:!0,user:a})}return log.error("Token extraction failed:",e.error),{success:!1,error:e.error}}return{success:!1,error:"No result from script injection"}}catch(e){return log.error("Script injection failed:",e),{success:!1,error:e.message}}}async function handleMessage(e,t){await ensureInitialized();const{action:o,data:a}=e;switch(o){case"setToken":return state.token=a.token,await saveState(),log.info("Token saved!"),{success:!0};case"getToken":return{token:state.token};case"clearToken":return state.token=null,await saveState(),log.info("Token cleared - user signed out"),{success:!0};case"validateToken":if(!state.token)return{valid:!1,reason:"No token"};try{return await apiFetch("/feed/v2?page=0&limit=1"),{valid:!0}}catch(e){return{valid:!1,reason:e.message}}case"getUserInfo":return getUserInfoFromToken();case"getSpeedPresets":return{presets:SPEED_PRESETS,current:state.config?.speed||"balanced"};case"setSpeed":const e=a.speed;return SPEED_PRESETS[e]?(state.config||(state.config={}),state.config.speed=e,await saveState(),log.info(`Speed set to: ${e} (API: ${SPEED_PRESETS[e].apiDelay}ms, Download: ${SPEED_PRESETS[e].downloadDelay}ms)`),{success:!0,speed:e}):{error:`Invalid speed: ${e}`};case"setIncludeStems":return state.config||(state.config={speed:"balanced",downloadPath:"SunoExplorer",includeStems:!1}),state.config.includeStems=!!a.includeStems,await saveState(),log.info(`Include stems set to: ${state.config.includeStems}`,state.config),{success:!0,includeStems:state.config.includeStems};case"getIncludeStems":const t=state.config?.includeStems||!1;return log.info(`getIncludeStems: ${t}`),{includeStems:t};case"getConfig":return{config:{speed:state.config?.speed||"balanced",downloadPath:state.config?.downloadPath||"SunoExplorer",includeStems:state.config?.includeStems||!1}};case"getUniqueCreators":const r=await loadClipsFromDB(),n=new Map;for(const e of r){const t=e.user_id;t&&(n.has(t)||n.set(t,{userId:t,handle:e.handle||null,displayName:e.display_name||e.handle||"Unknown",clipCount:0}),n.get(t).clipCount++)}return{creators:Array.from(n.values()).sort((e,t)=>t.clipCount-e.clipCount)};case"extractToken":return await extractTokenFromTab(a.tabId);case"getLibraryStatus":return await getLibraryStatus();case"getLibraryMeta":try{return{clipCount:await getClipCountFromDB(),lastIndexedAt:state.library.lastIndexedAt,feed:state.library.feed,liked:state.library.liked}}catch(e){return{clipCount:0,lastIndexedAt:null}}case"startIndexing":case"indexLibrary":return await indexLibrary(a||{});case"abortIndexing":return abortIndexing(),{success:!0};case"clearLibrary":return await clearLibrary();case"testDownload":return await testDownloadSettings();case"downloadFile":try{const e=state.config.downloadPath||"SunoExplorer";return await chrome.downloads.download({url:a.url,filename:`${e}/Stems/${a.filename}`,saveAs:!1}),{success:!0}}catch(e){return log.error("Download file error:",e),{success:!1,error:e.message}}case"getGroupedLibrary":return await getGroupedLibrary();case"exportLibrary":case"getLibraryForExport":try{const e=await loadClipsFromDB();if(!e||0===e.length)return{error:"No library data to export"};const t={clips:e,meta:{exportedAt:(new Date).toISOString(),clipCount:e.length,feed:state.library.feed,liked:state.library.liked}},o=JSON.stringify(t,null,2),a=`data:application/json;base64,${btoa(unescape(encodeURIComponent(o)))}`,r=`suno-library-${(new Date).toISOString().split("T")[0]}.json`;return await chrome.downloads.download({url:a,filename:r,saveAs:!0}),{success:!0,exported:e.length}}catch(e){return log.error("Export failed:",e),{error:e.message}}case"importLibrary":return await importLibrary(a.clips,a.meta);case"startSync":return await syncAll(a?.options||{});case"cancelSync":return isDownloading=!1,{success:!0};case"getSyncProgress":return{progress:downloadProgress,isDownloading:isDownloading};case"getDownloadStats":return await getDownloadStats();case"bulkMarkAsDownloaded":try{const{clipIds:e}=a;if(!e||!Array.isArray(e))return{success:!1,error:"No clip IDs provided"};const t=(await openDatabase()).transaction(["downloads"],"readwrite"),o=t.objectStore("downloads");for(const t of e)o.put({clipId:t,filename:`recovered_${t}`,filesize:0,downloadedAt:(new Date).toISOString(),status:"recovered"});return await new Promise((e,o)=>{t.oncomplete=e,t.onerror=()=>o(t.error)}),log.info(`Bulk marked ${e.length} clips as downloaded`),{success:!0,count:e.length}}catch(e){return log.error("Bulk mark downloaded failed:",e),{success:!1,error:e.message}}case"bulkClearDownloadStatus":try{const{clipIds:e}=a;if(!e||!Array.isArray(e))return{success:!1,error:"No clip IDs provided"};const t=(await openDatabase()).transaction(["downloads"],"readwrite"),o=t.objectStore("downloads");for(const t of e)o.delete(t);return await new Promise((e,o)=>{t.oncomplete=e,t.onerror=()=>o(t.error)}),log.info(`Cleared download status for ${e.length} clips`),{success:!0,cleared:e.length}}catch(e){return log.error("Bulk clear download status failed:",e),{success:!1,error:e.message}}case"clearDownloadHistory":return await clearDownloadHistory(),{success:!0};case"getDatabaseDiagnostics":return await getDatabaseDiagnostics();case"exportFullBackup":try{const e=await exportFullBackup(),t=JSON.stringify(e,null,2),o=`data:application/json;base64,${btoa(unescape(encodeURIComponent(t)))}`,a=`suno-explorer-full-backup-${(new Date).toISOString().split("T")[0]}.json`;return await chrome.downloads.download({url:o,filename:a,saveAs:!0}),{success:!0,summary:e.summary}}catch(e){return log.error("Export full backup failed:",e),{error:e.message}}case"exportCurationData":try{const e=await exportCurationData(),t=JSON.stringify(e,null,2),o=`data:application/json;base64,${btoa(unescape(encodeURIComponent(t)))}`,a=`suno-explorer-curation-${(new Date).toISOString().split("T")[0]}.json`;return await chrome.downloads.download({url:o,filename:a,saveAs:!0}),{success:!0,summary:e.summary}}catch(e){return log.error("Export curation data failed:",e),{error:e.message}}case"importFullBackup":try{return await importFullBackup(a.backup,a.merge||!1)}catch(e){return log.error("Import full backup failed:",e),{error:e.message}}case"importCurationData":try{return await importCurationData(a.curation,!1!==a.merge)}catch(e){return log.error("Import curation data failed:",e),{error:e.message}}case"getBackupSummary":try{const e=await getClipCountFromDB(),t=await getDownloadStats(),o=await getAllManualLinks(),a=await getUserPrefsRaw();return{clips:e,downloads:t.downloaded,manualLinks:Object.keys(o).length,customNames:Object.keys(a.customNames||{}).length,definitiveVersions:Object.keys(a.definitiveVersions||{}).length,publicClips:Object.values(a.visibility||{}).filter(e=>e).length,externalLinks:Object.keys(a.externalLinks||{}).length,lastIndexedAt:state.library.lastIndexedAt}}catch(e){return{error:e.message}}case"startChunkedImport":try{return await startChunkedImport(a.metadata,a.merge||!1)}catch(e){return log.error("Start chunked import failed:",e),{error:e.message}}case"addImportChunk":try{return await addImportChunk(a.chunkType,a.data)}catch(e){return log.error("Add import chunk failed:",e),{error:e.message}}case"finalizeChunkedImport":try{return await finalizeChunkedImport(a)}catch(e){return log.error("Finalize chunked import failed:",e),{error:e.message}}case"cancelChunkedImport":return await cancelChunkedImport();case"getStats":const s=state.clips.reduce((e,t)=>e+(t.metadata?.duration||0),0),i=Math.floor(s/3600),l=Math.floor(s%3600/60);return{stats:{totalClips:state.clips.length,syncedClips:state.clips.length,totalDurationFormatted:i>0?`${i}h ${l}m`:`${l}m`}};case"getSyncHistory":return{history:state.syncHistory||[]};case"setManualLink":return await setManualLink(a.childId,a.parentId),{success:!0};case"removeManualLink":return await removeManualLink(a.childId),{success:!0};case"getManualLink":return{link:await getManualLink(a.childId)};case"getAllManualLinks":return{links:await getAllManualLinks()};case"getUploadsBeforeDate":return{uploads:await getUploadsBeforeDate(a.beforeDate)};default:return{error:`Unknown action: ${o}`}}}chrome.runtime.onMessage.addListener((e,t,o)=>(log.debug("Message received:",e.action),handleMessage(e,t).then(e=>{log.debug("Sending response:",e),o(e)}).catch(e=>{log.error("Message handler error:",e),o({error:e.message})}),!0));let indexingAborted=!1;async function getLibraryStatus(){const e=state.library;if(!e.clipCount)try{e.clipCount=await getClipCountFromDB()}catch(t){e.clipCount=0}const t=e.clipCount||0,o=e.lastIndexedAt,a=e.feed?.complete&&e.liked?.complete,r=e.indexInProgress;let n="Never indexed";if(o){const e=Date.now()-new Date(o).getTime();n=e<6e4?"Just now":e<36e5?`${Math.round(e/6e4)} min ago`:e<864e5?`${Math.round(e/36e5)} hours ago`:`${Math.round(e/864e5)} days ago`}else t>0&&(n="Unknown (refresh recommended)");let s=null;if(r){const o=e.feed?.complete;s={phase:o?"indexing-liked":"indexing-feed",source:o?"liked":"feed",page:o?e.liked?.pagesIndexed:e.feed?.pagesIndexed,totalEstimate:o?e.liked?.totalEstimate:e.feed?.totalEstimate,clipsFound:t}}return{indexed:t,isComplete:a,inProgress:r,lastIndexed:o,ageText:n,feedPages:e.feed?.pagesIndexed||0,likedPages:e.liked?.pagesIndexed||0,feedComplete:e.feed?.complete||!1,likedComplete:e.liked?.complete||!1,feedTotal:e.feed?.totalEstimate,likedTotal:e.liked?.totalEstimate,currentProgress:s}}async function indexLibrary(e={}){if(!state.token)return{error:"Not connected"};if(state.library.indexInProgress)return{error:"Indexing already in progress"};const{includeFeed:t=!0,includeLiked:o=!0,resume:a=!0,refreshMode:r=!1}=e;state.library.indexInProgress=!0,indexingAborted=!1,log.info(`Index options: resume=${a}, refresh=${r}, includeFeed=${t}, includeLiked=${o}`),a||r||(log.info("Fresh index: clearing all clips and resetting state"),await clearClipsFromDB(),state.library.clips=[],state.library.clipCount=0,state.library.feed={pagesIndexed:0,totalEstimate:null,complete:!1},state.library.liked={pagesIndexed:0,totalEstimate:null,complete:!1},state.library.lastIndexedAt=null,await saveLibraryMeta()),r&&(log.info("Refresh mode: will update existing clips with fresh metadata"),state.library.feed={pagesIndexed:0,totalEstimate:null,complete:!1},state.library.liked={pagesIndexed:0,totalEstimate:null,complete:!1});const n=r?new Set:await getClipIdsFromDB();log.info(`Existing clips in DB: ${n.size}${r?" (refresh mode - will update all)":""}`);let s=null;try{if(t){let e=0;a&&state.library.feed.pagesIndexed>0&&!state.library.feed.complete&&(e=Math.max(0,state.library.feed.pagesIndexed-2),log.info(`Smart resume: starting feed from page ${e} (was at ${state.library.feed.pagesIndexed})`));let t=e,o=!0,i=0,l=!1,d=0;for(log.info(`Indexing feed from page ${t} (will skip ${n.size} already indexed)...`);o&&!indexingAborted;){const e=state.config.includeStems?"false":"true";0===t&&log.info("Indexing with stems: "+(state.config.includeStems?"INCLUDED":"HIDDEN"));const a=new URLSearchParams({hide_disliked:"false",hide_gen_stems:e,hide_studio_clips:"true",page:t.toString()}),c=await apiFetch(`/feed/v2?${a}`),u=c.clips||[];0===t&&c.num_total_results&&(state.library.feed.totalEstimate=c.num_total_results),!s&&u.length>0&&u[0].user_id&&(s=u[0].user_id,log.info(`Current user ID: ${s}`));let g=0;const p=[];for(const e of u)n.has(e.id)||(p.push(e),n.add(e.id),g++,i++);if(p.length>0&&(await saveClipsToDB(p),r?state.library.clipCount=await getClipCountFromDB():state.library.clipCount+=p.length),0===g&&u.length>0){if(d++,d>=3||state.library.feed.complete){log.info(`Feed page ${t}: ${d} consecutive pages of existing content, stopping`),l=!0;break}}else d=0;state.library.feed.pagesIndexed=t+1,o=c.has_more&&u.length>0,broadcastIndexProgress({phase:"indexing-feed",source:"feed",page:t+1,totalEstimate:state.library.feed.totalEstimate,clipsFound:state.library.clipCount,newFound:i}),await saveLibraryMeta(),log.info(`Feed page ${t}: +${g} new clips (total: ${state.library.clipCount})`),t++}indexingAborted||(state.library.feed.complete=!0,log.info(`Feed indexing complete: ${i} new songs found`))}if(o&&!indexingAborted){let e=1;a&&state.library.liked.pagesIndexed>0&&!state.library.liked.complete&&(e=Math.max(1,state.library.liked.pagesIndexed-1),log.info(`Smart resume: starting liked from page ${e} (was at ${state.library.liked.pagesIndexed})`));let t=e,o=!0,i=0,l=0;for(log.info(`Indexing liked from page ${t} (will skip already indexed)...`);o&&!indexingAborted;){const e=await apiFetch(`/playlist/liked/?page=${t}`),a=e.playlist_clips||[];1===t&&e.num_total_results&&(state.library.liked.totalEstimate=e.num_total_results);let d=0;const c=[],u=[];let g=0;for(const e of a){const t=e.clip||e;t.id?s&&t.user_id&&t.user_id!==s?g++:(t.is_liked=!0,n.has(t.id)?u.push(t):(c.push(t),n.add(t.id),d++,i++)):log.warn("Skipping clip without ID",e)}if(c.length>0&&(await saveClipsToDB(c),r?state.library.clipCount=await getClipCountFromDB():state.library.clipCount+=c.length),u.length>0&&await saveClipsToDB(u),0===d&&a.length>0){if(l++,l>=3||state.library.liked.complete){log.info(`Liked page ${t}: ${l} consecutive pages of existing content, stopping`);break}}else l=0;state.library.liked.pagesIndexed=t,o=a.length>0,broadcastIndexProgress({phase:"indexing-liked",source:"liked",page:t,totalEstimate:state.library.liked.totalEstimate,clipsFound:state.library.clipCount,newFound:i}),await saveLibraryMeta(),log.info(`Liked page ${t}: +${d} new clips (total: ${state.library.clipCount})${g>0?`, skipped ${g} from other users`:""}`),t++}indexingAborted||(state.library.liked.complete=!0,log.info(`Liked indexing complete: ${i} new songs found`))}state.library.clipCount=await getClipCountFromDB(),indexingAborted||(state.library.lastIndexedAt=(new Date).toISOString(),log.info(`Indexing complete! Setting lastIndexedAt to: ${state.library.lastIndexedAt}`)),await saveLibraryMeta(),await saveState();const e=await chrome.storage.local.get(["sunoOfflineConfig"]);return log.info("Verified saved config:",{lastIndexedAt:e.sunoOfflineConfig?.lastIndexedAt,clipCount:e.sunoOfflineConfig?.clipCount,feedComplete:e.sunoOfflineConfig?.feed?.complete,likedComplete:e.sunoOfflineConfig?.liked?.complete}),broadcastIndexProgress({phase:indexingAborted?"paused":"complete",clipsFound:state.library.clipCount}),log.info(`Indexing ${indexingAborted?"paused":"complete"}: ${state.library.clipCount} clips`),{success:!0,indexed:state.library.clipCount,aborted:indexingAborted}}catch(e){return log.error("Indexing failed:",e),broadcastIndexProgress({phase:"error",error:e.message}),{error:e.message}}finally{state.library.indexInProgress=!1,await saveLibraryMeta()}}function abortIndexing(){indexingAborted=!0,log.info("Indexing abort requested")}function broadcastIndexProgress(e){chrome.runtime.sendMessage({action:"indexProgress",progress:e}).catch(()=>{})}async function importLibrary(e,t){if(!e||!Array.isArray(e))return{error:"Invalid import data"};if(log.info(`Importing ${e.length} clips...`),await clearClipsFromDB(),await saveClipsToDB(e),state.library.clipCount=e.length,state.library.lastIndexedAt=t?.exportedAt||(new Date).toISOString(),state.library.feed=t?.feed||state.library.feed,state.library.liked=t?.liked||state.library.liked,await saveLibraryMeta(),t?.downloadRecords&&Array.isArray(t.downloadRecords))try{await importDownloadRecords(t.downloadRecords,!1),log.info(`Also imported ${t.downloadRecords.length} download records`)}catch(e){log.warn("Failed to import download records:",e)}return log.info(`Import complete: ${e.length} clips`),{success:!0,imported:e.length}}async function clearLibrary(){return await clearClipsFromDB(),state.library={clips:[],clipCount:0,lastIndexedAt:null,indexInProgress:!1,feed:{pagesIndexed:0,totalEstimate:null,complete:!1},liked:{pagesIndexed:0,totalEstimate:null,complete:!1}},await saveState(),log.info("Library cleared (IndexedDB + config)"),{success:!0}}async function exportFullBackup(){log.info("Creating full backup...");try{const e=await loadClipsFromDB(),t=await getAllDownloadRecords(),o=await getAllManualLinks(),a=await chrome.storage.local.get(["sunoOfflinePrefs","sunoOfflineSettings","sunoOfflineConfig"]),r={version:1,exportedAt:(new Date).toISOString(),exportedBy:"Suno Explorer",clips:e,clipCount:e.length,downloads:t,manualLinks:o,userPrefs:a.sunoOfflinePrefs||{},settings:a.sunoOfflineSettings||{},config:{lastIndexedAt:a.sunoOfflineConfig?.lastIndexedAt,feed:a.sunoOfflineConfig?.feed,liked:a.sunoOfflineConfig?.liked},summary:{totalClips:e.length,totalDownloads:t.length,manualLinksCount:Object.keys(o).length,customNamesCount:Object.keys(a.sunoOfflinePrefs?.customNames||{}).length,definitiveVersionsCount:Object.keys(a.sunoOfflinePrefs?.definitiveVersions||{}).length,publicClipsCount:Object.values(a.sunoOfflinePrefs?.visibility||{}).filter(e=>e).length,externalLinksCount:Object.keys(a.sunoOfflinePrefs?.externalLinks||{}).length}};return log.info("Full backup created:",r.summary),r}catch(e){throw log.error("Failed to create full backup:",e),e}}async function exportCurationData(){log.info("Creating curation-only backup...");try{const e=await getAllManualLinks(),t=(await chrome.storage.local.get(["sunoOfflinePrefs"])).sunoOfflinePrefs||{},o={version:1,type:"curation-only",exportedAt:(new Date).toISOString(),exportedBy:"Suno Explorer",manualLinks:e,customNames:t.customNames||{},definitiveVersions:t.definitiveVersions||{},visibility:t.visibility||{},externalLinks:t.externalLinks||{},releaseStatus:t.releaseStatus||{},hideUnliked:t.hideUnliked||{},customArt:t.customArt||{},disliked:t.disliked||{},summary:{manualLinksCount:Object.keys(e).length,customNamesCount:Object.keys(t.customNames||{}).length,definitiveVersionsCount:Object.keys(t.definitiveVersions||{}).length,publicClipsCount:Object.values(t.visibility||{}).filter(e=>e).length,externalLinksCount:Object.keys(t.externalLinks||{}).length,hiddenSongsCount:Object.keys(t.hideUnliked||{}).length,customArtCount:Object.keys(t.customArt||{}).length}};return log.info("Curation backup created:",o.summary),o}catch(e){throw log.error("Failed to create curation backup:",e),e}}async function importFullBackup(e,t=!1){if(log.info(`Importing full backup (merge: ${t})...`),!e||void 0===e.version)throw new Error("Invalid backup format");try{return e.clips&&e.clips.length>0&&(t||await clearClipsFromDB(),await saveClipsToDB(e.clips),state.library.clipCount=await getClipCountFromDB(),log.info(`Imported ${e.clips.length} clips`)),e.downloads&&e.downloads.length>0&&(await importDownloadRecords(e.downloads,t),log.info(`Imported ${e.downloads.length} download records`)),e.manualLinks&&Object.keys(e.manualLinks).length>0&&(await importManualLinks(e.manualLinks,t),log.info(`Imported ${Object.keys(e.manualLinks).length} manual links`)),e.userPrefs&&(await importUserPrefs(e.userPrefs,t),log.info("Imported user preferences")),e.config&&(state.library.lastIndexedAt=e.config.lastIndexedAt||e.exportedAt,state.library.feed=e.config.feed||state.library.feed,state.library.liked=e.config.liked||state.library.liked,await saveLibraryMeta()),log.info("Full backup import complete"),{success:!0,imported:{clips:e.clips?.length||0,downloads:e.downloads?.length||0,manualLinks:Object.keys(e.manualLinks||{}).length,preferences:!!e.userPrefs}}}catch(e){throw log.error("Failed to import full backup:",e),e}}let chunkedImportState=null;async function startChunkedImport(e,t=!1){return log.info("Starting chunked import...",e),chunkedImportState={merge:t,metadata:e,clips:[],downloads:[],totalClipsExpected:e.totalClips||0,totalDownloadsExpected:e.totalDownloads||0,receivedClips:0,receivedDownloads:0},t||(await clearClipsFromDB(),log.info("Cleared existing clips for fresh import")),{success:!0,sessionStarted:!0}}async function addImportChunk(e,t){if(!chunkedImportState)throw new Error("No import session active. Call startChunkedImport first.");return"clips"===e&&Array.isArray(t)?(await saveClipsToDB(t),chunkedImportState.receivedClips+=t.length,broadcastImportProgress({phase:"importing_clips",received:chunkedImportState.receivedClips,total:chunkedImportState.totalClipsExpected}),log.debug(`Received clip chunk: ${t.length} clips (total: ${chunkedImportState.receivedClips})`),{success:!0,received:chunkedImportState.receivedClips,total:chunkedImportState.totalClipsExpected}):"downloads"===e&&Array.isArray(t)?(await importDownloadRecords(t,chunkedImportState.merge),chunkedImportState.receivedDownloads+=t.length,log.debug(`Received downloads chunk: ${t.length} records`),{success:!0,received:chunkedImportState.receivedDownloads,total:chunkedImportState.totalDownloadsExpected}):{error:"Unknown chunk type"}}async function finalizeChunkedImport(e){if(!chunkedImportState)throw new Error("No import session active");log.info("Finalizing chunked import...");try{e?.manualLinks&&Object.keys(e.manualLinks).length>0&&(await importManualLinks(e.manualLinks,chunkedImportState.merge),log.info(`Imported ${Object.keys(e.manualLinks).length} manual links`)),e?.userPrefs&&(await importUserPrefs(e.userPrefs,chunkedImportState.merge),log.info("Imported user preferences")),state.library.clipCount=await getClipCountFromDB(),state.library.lastIndexedAt=chunkedImportState.metadata?.exportedAt||(new Date).toISOString(),chunkedImportState.metadata?.config&&(state.library.feed=chunkedImportState.metadata.config.feed||state.library.feed,state.library.liked=chunkedImportState.metadata.config.liked||state.library.liked),await saveLibraryMeta();const t={success:!0,imported:{clips:chunkedImportState.receivedClips,downloads:chunkedImportState.receivedDownloads,manualLinks:Object.keys(e?.manualLinks||{}).length,preferences:!!e?.userPrefs}};return chunkedImportState=null,broadcastImportProgress({phase:"complete"}),log.info("Chunked import complete:",t.imported),t}catch(e){throw chunkedImportState=null,log.error("Failed to finalize chunked import:",e),e}}async function cancelChunkedImport(){return chunkedImportState?(log.info("Cancelling chunked import"),chunkedImportState=null,{success:!0}):{success:!0,message:"No import in progress"}}function broadcastImportProgress(e){chrome.runtime.sendMessage({action:"importProgress",progress:e}).catch(()=>{})}async function importCurationData(e,t=!0){if(log.info(`Importing curation data (merge: ${t})...`),!e||void 0===e.version)throw new Error("Invalid curation format");try{e.manualLinks&&await importManualLinks(e.manualLinks,t);const o=t?await getUserPrefsRaw():{};return e.customNames&&(o.customNames=t?{...o.customNames,...e.customNames}:e.customNames),e.definitiveVersions&&(o.definitiveVersions=t?{...o.definitiveVersions,...e.definitiveVersions}:e.definitiveVersions),e.visibility&&(o.visibility=t?{...o.visibility,...e.visibility}:e.visibility),e.externalLinks&&(o.externalLinks=t?{...o.externalLinks,...e.externalLinks}:e.externalLinks),e.releaseStatus&&(o.releaseStatus=t?{...o.releaseStatus,...e.releaseStatus}:e.releaseStatus),e.hideUnliked&&(o.hideUnliked=t?{...o.hideUnliked,...e.hideUnliked}:e.hideUnliked),e.customArt&&(o.customArt=t?{...o.customArt,...e.customArt}:e.customArt),e.disliked&&(o.disliked=t?{...o.disliked,...e.disliked}:e.disliked),await chrome.storage.local.set({sunoOfflinePrefs:o}),log.info("Curation import complete:",e.summary),{success:!0,imported:e.summary}}catch(e){throw log.error("Failed to import curation data:",e),e}}async function getUserPrefsRaw(){return(await chrome.storage.local.get(["sunoOfflinePrefs"])).sunoOfflinePrefs||{}}async function getAllDownloadRecords(){const e=await openDatabase();return e.objectStoreNames.contains("downloads")?new Promise((t,o)=>{const a=e.transaction(["downloads"],"readonly").objectStore("downloads").getAll();a.onsuccess=()=>t(a.result||[]),a.onerror=()=>o(a.error)}):[]}async function importDownloadRecords(e,t){const o=await openDatabase();if(o.objectStoreNames.contains("downloads"))return new Promise((a,r)=>{const n=o.transaction(["downloads"],"readwrite"),s=n.objectStore("downloads");t||s.clear();for(const t of e)s.put(t);n.oncomplete=()=>a(),n.onerror=()=>r(n.error)});log.warn("Downloads store does not exist")}async function importManualLinks(e,t){const o=await openDatabase();if(o.objectStoreNames.contains("manualLinks"))return new Promise((a,r)=>{const n=o.transaction(["manualLinks"],"readwrite"),s=n.objectStore("manualLinks");t||s.clear();for(const[t,o]of Object.entries(e))s.put({childId:t,parentId:o,linkedAt:(new Date).toISOString()});n.oncomplete=()=>a(),n.onerror=()=>r(n.error)});log.warn("Manual links store does not exist")}async function importUserPrefs(e,t){if(t){const t=await getUserPrefsRaw(),o={customNames:{...t.customNames,...e.customNames},definitiveVersions:{...t.definitiveVersions,...e.definitiveVersions},visibility:{...t.visibility,...e.visibility},externalLinks:{...t.externalLinks,...e.externalLinks},releaseStatus:{...t.releaseStatus,...e.releaseStatus},hideUnliked:{...t.hideUnliked,...e.hideUnliked},customArt:{...t.customArt,...e.customArt},disliked:{...t.disliked,...e.disliked}};await chrome.storage.local.set({sunoOfflinePrefs:o})}else await chrome.storage.local.set({sunoOfflinePrefs:e})}async function getGroupedLibrary(){const e=await loadClipsFromDB(),t=new Map;for(const o of e){const e=normalizeTitle(o.title);t.has(e)||t.set(e,{id:o.id,baseTitle:e,displayTitle:o.title||e||"Untitled",versions:[],likedVersions:0,hasLikedVersion:!1,latestDate:null,earliestDate:null,totalDuration:0});const a=t.get(e);a.versions.push(o),a.totalDuration+=o.metadata?.duration||0,o.is_liked&&(a.likedVersions++,a.hasLikedVersion=!0);const r=new Date(o.created_at);(!a.latestDate||r>a.latestDate)&&(a.latestDate=r,a.displayTitle=o.title||a.displayTitle||e||"Untitled"),(!a.earliestDate||r<a.earliestDate)&&(a.earliestDate=r)}for(const e of t.values())e.versions.sort((e,t)=>new Date(e.created_at)-new Date(t.created_at)),e.versions.forEach((t,o)=>{t._version=e.versions.length>1?o+1:null,t._baseTitle=e.baseTitle}),e.imageUrl=e.versions[0]?.image_url,e.imageLargeUrl=e.versions[0]?.image_large_url,e.latestDate=e.latestDate?.toISOString(),e.earliestDate=e.earliestDate?.toISOString();const o=Array.from(t.values()).sort((e,t)=>new Date(t.latestDate)-new Date(e.latestDate));return log.info(`Grouped ${e.length} clips into ${o.length} unique songs`),{songs:o,totalClips:e.length,uniqueSongs:o.length,withMultipleVersions:o.filter(e=>e.versions.length>1).length}}let isInitialized=!1;async function ensureInitialized(){isInitialized||(await loadState(),isInitialized=!0)}(async()=>{try{await openDatabase(),await migrateFromChromeStorage(),await loadState(),isInitialized=!0,log.info("Background worker started",{token:state.token?"present":"missing",clipCount:state.library.clipCount})}catch(e){log.error("Initialization failed",e)}})(),chrome.runtime.onInstalled.addListener(()=>{log.info("Suno Explorer installed!")});